/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.pulsar.client.admin.utils.DefaultImplementation;

final class ReflectionUtils {
    static <T> T catchExceptions(SupplierWithException<T> s) {
        try {
            return s.get();
        }
        catch (Throwable t) {
            if (t instanceof InvocationTargetException) {
                Throwable cause = t.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            throw new RuntimeException(t);
        }
    }

    static <T> Class<T> newClassInstance(String className) {
        try {
            try {
                return DefaultImplementation.class.getClassLoader().loadClass(className);
            }
            catch (Exception e) {
                return Thread.currentThread().getContextClassLoader().loadClass(className);
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new RuntimeException(e);
        }
    }

    static <T> Constructor<T> getConstructor(String className, Class<?> ... argTypes) {
        try {
            Class<T> clazz = ReflectionUtils.newClassInstance(className);
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static <T> Method getStaticMethod(String className, String method, Class<?> ... argTypes) {
        try {
            Class<T> clazz = ReflectionUtils.newClassInstance(className);
            return clazz.getMethod(method, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static interface SupplierWithException<T> {
        public T get() throws Exception;
    }
}

