/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.LogRecordSet;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.exceptions.LogRecordTooLongException;
import org.apache.distributedlog.io.CompressionCodec;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogRecordSet {
    private static final Logger log = LoggerFactory.getLogger(TestLogRecordSet.class);

    @Test(timeout=60000L)
    public void testEmptyRecordSet() throws Exception {
        LogRecordSet.Writer writer = LogRecordSet.newWriter((int)1024, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ByteBuf buffer = writer.getBuffer();
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)buffer.readableBytes());
        LogRecordWithDLSN record = new LogRecordWithDLSN(new DLSN(1L, 0L, 0L), 1L, buffer, 1L);
        record.setRecordSet();
        LogRecordSet.Reader reader = LogRecordSet.of((LogRecordWithDLSN)record);
        Assert.assertNull((String)"Empty record set should return null", (Object)reader.nextRecord());
        reader.release();
    }

    @Test(timeout=60000L)
    public void testWriteTooLongRecord() throws Exception {
        LogRecordSet.Writer writer = LogRecordSet.newWriter((int)1024, (CompressionCodec.Type)CompressionCodec.Type.NONE);
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ByteBuffer dataBuf = ByteBuffer.allocate(1040385);
        try {
            writer.writeRecord(dataBuf, new CompletableFuture());
            Assert.fail((String)"Should fail on writing large record");
        }
        catch (LogRecordTooLongException logRecordTooLongException) {
            // empty catch block
        }
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ByteBuf buffer = writer.getBuffer();
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)buffer.readableBytes());
        LogRecordWithDLSN record = new LogRecordWithDLSN(new DLSN(1L, 0L, 0L), 1L, buffer, 1L);
        record.setRecordSet();
        LogRecordSet.Reader reader = LogRecordSet.of((LogRecordWithDLSN)record);
        Assert.assertNull((String)"Empty record set should return null", (Object)reader.nextRecord());
        reader.release();
    }

    @Test(timeout=20000L)
    public void testWriteRecordsNoneCompressed() throws Exception {
        this.testWriteRecords(CompressionCodec.Type.NONE);
    }

    @Test(timeout=20000L)
    public void testWriteRecordsLZ4Compressed() throws Exception {
        this.testWriteRecords(CompressionCodec.Type.LZ4);
    }

    void testWriteRecords(CompressionCodec.Type codec) throws Exception {
        LogRecordSet.Writer writer = LogRecordSet.newWriter((int)1024, (CompressionCodec.Type)codec);
        Assert.assertEquals((String)"zero user bytes", (long)16L, (long)writer.getNumBytes());
        Assert.assertEquals((String)"zero records", (long)0L, (long)writer.getNumRecords());
        ArrayList writePromiseList = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            ByteBuffer record = ByteBuffer.wrap(("record-" + i).getBytes(StandardCharsets.UTF_8));
            CompletableFuture writePromise = new CompletableFuture();
            writer.writeRecord(record, writePromise);
            writePromiseList.add(writePromise);
            Assert.assertEquals((String)(i + 1 + " records"), (long)(i + 1), (long)writer.getNumRecords());
        }
        ByteBuffer dataBuf = ByteBuffer.allocate(1040385);
        try {
            writer.writeRecord(dataBuf, new CompletableFuture());
            Assert.fail((String)"Should fail on writing large record");
        }
        catch (LogRecordTooLongException record) {
            // empty catch block
        }
        Assert.assertEquals((String)"5 records", (long)5L, (long)writer.getNumRecords());
        for (int i = 0; i < 5; ++i) {
            ByteBuffer record = ByteBuffer.wrap(("record-" + (i + 5)).getBytes(StandardCharsets.UTF_8));
            CompletableFuture writePromise = new CompletableFuture();
            writer.writeRecord(record, writePromise);
            writePromiseList.add(writePromise);
            Assert.assertEquals((String)(i + 6 + " records"), (long)(i + 6), (long)writer.getNumRecords());
        }
        ByteBuf buffer = writer.getBuffer();
        Assert.assertEquals((String)"10 records", (long)10L, (long)writer.getNumRecords());
        writer.completeTransmit(1L, 1L, 10L);
        List writeResults = (List)FutureUtils.result((CompletableFuture)FutureUtils.collect((List)writePromiseList));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, 10L + (long)i), writeResults.get(i));
        }
        LogRecordWithDLSN record = new LogRecordWithDLSN(new DLSN(1L, 1L, 10L), 99L, buffer, 999L);
        record.setPositionWithinLogSegment(888);
        record.setRecordSet();
        LogRecordSet.Reader reader = LogRecordSet.of((LogRecordWithDLSN)record);
        LogRecordWithDLSN readRecord = reader.nextRecord();
        int numReads = 0;
        while (null != readRecord) {
            Assert.assertEquals((Object)new DLSN(1L, 1L, 10L + (long)numReads), (Object)readRecord.getDlsn());
            Assert.assertEquals((long)99L, (long)readRecord.getTransactionId());
            Assert.assertEquals((long)(888 + numReads), (long)readRecord.getPositionWithinLogSegment());
            Assert.assertEquals((long)999L, (long)readRecord.getStartSequenceIdOfCurrentSegment());
            Assert.assertEquals((long)(1887L + (long)numReads - 1L), (long)readRecord.getSequenceId());
            ++numReads;
            readRecord = reader.nextRecord();
        }
        Assert.assertEquals((long)10L, (long)numReads);
        reader.release();
    }
}

