/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.framework;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.WrappedParameter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import org.apache.bookkeeper.shaded.com.google.common.collect.Lists;
import org.apache.bookkeeper.tools.framework.Command;
import org.apache.commons.lang.StringUtils;

public class CommandUtils {
    private static final int MAX_COLUMN_SIZE = 79;
    private static final int DEFAULT_INDENT = 4;
    private static final String USAGE_HEADER = "Usage:";
    private static final Comparator<? super ParameterDescription> PD_COMPARATOR = (p0, p1) -> p0.getLongestName().compareTo(p1.getLongestName());

    private static void printIndent(PrintStream printer, int indent) {
        IntStream.range(0, indent).forEach(ignored -> printer.print(" "));
    }

    public static void printUsage(PrintStream printer, String usage) {
        int indent = (USAGE_HEADER.length() / 4 + 1) * 4;
        int firstIndent = indent - USAGE_HEADER.length();
        printer.print(USAGE_HEADER);
        CommandUtils.printDescription(printer, firstIndent, indent, usage);
        printer.println();
    }

    public static void printAvailableFlags(JCommander commander, PrintStream printer) {
        ArrayList<ParameterDescription> sorted = Lists.newArrayList();
        List pds = commander.getParameters();
        int longestName = 0;
        for (ParameterDescription pd : pds) {
            if (pd.getParameter().hidden()) continue;
            sorted.add(pd);
            int length = pd.getNames().length() + 2;
            if (length <= longestName) continue;
            longestName = length;
        }
        if (sorted.isEmpty()) {
            return;
        }
        Collections.sort(sorted, PD_COMPARATOR);
        printer.println("Flags:");
        printer.println();
        ParameterDescription helpPd = null;
        for (ParameterDescription pd : sorted) {
            if ("--help".equals(pd.getLongestName())) {
                helpPd = pd;
                continue;
            }
            CommandUtils.printFlag(pd, 4, printer);
            printer.println();
        }
        if (null != helpPd) {
            printer.println();
            CommandUtils.printFlag(helpPd, 4, printer);
            printer.println();
        }
    }

    private static void printFlag(ParameterDescription pd, int indent, PrintStream printer) {
        WrappedParameter parameter = pd.getParameter();
        CommandUtils.printIndent(printer, indent);
        printer.print(pd.getNames());
        printer.print(parameter.required() ? " (*)" : "");
        printer.println();
        int descIndent = 2 * indent;
        CommandUtils.printDescription(printer, descIndent, descIndent, pd.getDescription());
    }

    public static void printDescription(PrintStream printer, int firstLineIndent, int indent, String description) {
        int max = 79;
        String[] words = description.split(" ");
        int current = indent;
        CommandUtils.printIndent(printer, firstLineIndent);
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (word.length() > max || current + word.length() <= max) {
                if (i != 0) {
                    printer.print(" ");
                }
                printer.print(word);
                current += word.length() + 1;
                continue;
            }
            printer.println();
            CommandUtils.printIndent(printer, indent);
            printer.print(word);
            current = indent;
        }
        printer.println();
    }

    public static void printAvailableCommands(Map<String, Command> commands, PrintStream printer) {
        Map subCommands;
        String category;
        if (commands.isEmpty()) {
            return;
        }
        int longestCommandName = commands.keySet().stream().mapToInt(name -> name.length()).max().orElse(0);
        TreeMap categorizedCommands = new TreeMap();
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            if ("help".equals(entry.getKey())) continue;
            category = entry.getValue().category();
            subCommands = (TreeMap<String, Command>)categorizedCommands.get(category);
            if (null == subCommands) {
                subCommands = new TreeMap<String, Command>();
                categorizedCommands.put(category, subCommands);
            }
            subCommands.put(entry.getKey(), entry.getValue());
        }
        if (categorizedCommands.size() <= 1) {
            printer.println("Commands:");
            printer.println();
        }
        for (Map.Entry<String, Command<Object>> entry : categorizedCommands.entrySet()) {
            category = entry.getKey();
            CommandUtils.printCategoryHeader(printer, category);
            subCommands = (Map)((Object)entry.getValue());
            for (Map.Entry commandEntry : subCommands.entrySet()) {
                CommandUtils.printCommand(printer, (String)commandEntry.getKey(), (Command)commandEntry.getValue(), longestCommandName);
            }
            printer.println();
        }
        Command helpCmd = commands.get("help");
        if (null != helpCmd) {
            if (categorizedCommands.size() > 1) {
                CommandUtils.printCategoryHeader(printer, "Other commands");
            }
            CommandUtils.printCommand(printer, "help", helpCmd, longestCommandName);
        }
        printer.println();
    }

    private static void printCommand(PrintStream printer, String name, Command command, int longestCommandName) {
        if (command.hidden()) {
            return;
        }
        int indent = 4;
        int startOfDescription = ((4 + longestCommandName) / 4 + 2) * 4;
        int current = 0;
        CommandUtils.printIndent(printer, 4);
        printer.print(name);
        CommandUtils.printIndent(printer, startOfDescription - (current += 4 + name.length()));
        CommandUtils.printDescription(printer, 0, startOfDescription, command.description());
    }

    private static void printCategoryHeader(PrintStream printer, String category) {
        if (StringUtils.isEmpty((String)category)) {
            return;
        }
        CommandUtils.printIndent(printer, 0);
        CommandUtils.printDescription(printer, 0, 0, category + " :");
        printer.println();
    }
}

