/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.cookie;

import com.beust.jcommander.Parameter;
import java.io.PrintStream;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.tools.cli.commands.cookie.CookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateCookieCommand
extends CookieCommand<Flags> {
    private static final Logger log = LoggerFactory.getLogger(CreateCookieCommand.class);
    private static final String NAME = "create";
    private static final String DESC = "Create a cookie for a given bookie";

    public CreateCookieCommand() {
        this(new Flags());
    }

    protected CreateCookieCommand(PrintStream console) {
        this(new Flags(), console);
    }

    public CreateCookieCommand(Flags flags) {
        this(flags, System.out);
    }

    private CreateCookieCommand(Flags flags, PrintStream console) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).withConsole(console).withArgumentsUsage("<bookie-id>").build());
    }

    @Override
    protected void apply(RegistrationManager rm, Flags cmdFlags) throws Exception {
        BookieId bookieId = this.getBookieId(cmdFlags);
        byte[] data = this.readCookieDataFromFile(cmdFlags.cookieFile);
        Versioned<byte[]> cookie = new Versioned<byte[]>(data, Version.NEW);
        try {
            rm.writeCookie(bookieId, cookie);
        }
        catch (BookieException.CookieExistException cee) {
            this.spec.console().println("Cookie already exist for bookie '" + bookieId + "'");
            throw cee;
        }
        catch (BookieException be) {
            this.spec.console().println("Exception on creating cookie for bookie '" + bookieId + "'");
            be.printStackTrace(this.spec.console());
            throw be;
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-cf", "--cookie-file"}, description="The file to be uploaded as cookie", required=true)
        private String cookieFile;

        public Flags cookieFile(String cookieFile) {
            this.cookieFile = cookieFile;
            return this;
        }
    }
}

