/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.autorecovery;

import java.io.IOException;
import java.util.Collections;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoIsAuditorCommand
extends BookieCommand<CliFlags> {
    static final Logger LOG = LoggerFactory.getLogger(WhoIsAuditorCommand.class);
    private static final String NAME = "whoisauditor";
    private static final String DESC = "Print the node which holds the auditor lock.";
    private BookKeeperAdmin bka;

    public WhoIsAuditorCommand() {
        this((BookKeeperAdmin)null);
    }

    public WhoIsAuditorCommand(BookKeeperAdmin bka) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(new CliFlags()).build());
        this.bka = bka;
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags cmdFlags) {
        try {
            return this.getAuditor(conf);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getAuditor(ServerConfiguration conf) throws BKException, InterruptedException, IOException {
        BookieId bookieId;
        ClientConfiguration clientConfiguration = new ClientConfiguration(conf);
        if (this.bka != null) {
            bookieId = this.bka.getCurrentAuditor();
        } else {
            BookKeeperAdmin bka = new BookKeeperAdmin(clientConfiguration);
            try {
                bookieId = bka.getCurrentAuditor();
            }
            finally {
                if (Collections.singletonList(bka).get(0) != null) {
                    bka.close();
                }
            }
        }
        if (bookieId == null) {
            LOG.info("No auditor elected");
            return false;
        }
        LOG.info("Auditor: " + bookieId);
        return true;
    }
}

