/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerMetadataSerDe;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.shaded.com.google.common.base.Preconditions;
import org.apache.bookkeeper.shaded.com.google.common.collect.Maps;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListLedgerService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;
    private final LedgerMetadataSerDe serDe;
    static final int LIST_LEDGER_BATCH_SIZE = 100;

    public ListLedgerService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull(conf);
        this.conf = conf;
        this.bookieServer = bookieServer;
        this.serDe = new LedgerMetadataSerDe();
    }

    private void keepLedgerMetadata(long ledgerId, CompletableFuture<Versioned<LedgerMetadata>> future, LinkedHashMap<String, Object> output, boolean decodeMeta) throws Exception {
        LedgerMetadata md = future.get().getValue();
        if (decodeMeta) {
            output.put(Long.valueOf(ledgerId).toString(), md);
        } else {
            output.put(Long.valueOf(ledgerId).toString(), new String(this.serDe.serialize(md), StandardCharsets.UTF_8));
        }
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            Map params = request.getParams();
            boolean printMeta = params != null && params.containsKey("print_metadata") && ((String)params.get("print_metadata")).equals("true");
            boolean decodeMeta = params != null && params.getOrDefault("decode_meta", "false").equals("true");
            int pageIndex = printMeta && params.containsKey("page") ? Integer.parseInt((String)params.get("page")) : -1;
            LedgerManagerFactory mFactory = this.bookieServer.getBookie().getLedgerManagerFactory();
            LedgerManager manager = mFactory.newLedgerManager();
            LedgerManager.LedgerRangeIterator iter = manager.getLedgerRanges(0L);
            LinkedHashMap<String, Object> output = Maps.newLinkedHashMap();
            LinkedHashMap<Long, CompletableFuture<Versioned<LedgerMetadata>>> futures = new LinkedHashMap<Long, CompletableFuture<Versioned<LedgerMetadata>>>(100);
            if (printMeta) {
                int ledgerIndex = 0;
                int startLedgerIndex = 0;
                int endLedgerIndex = 0;
                if (pageIndex > 0) {
                    startLedgerIndex = (pageIndex - 1) * 100;
                    endLedgerIndex = startLedgerIndex + 100 - 1;
                }
                while (iter.hasNext()) {
                    LedgerManager.LedgerRange r = iter.next();
                    for (Long l : r.getLedgers()) {
                        if (endLedgerIndex != 0 && (++ledgerIndex < startLedgerIndex || ledgerIndex > endLedgerIndex)) continue;
                        futures.put(l, manager.readLedgerMetadata(l));
                    }
                    if (futures.size() < 100) continue;
                    for (Map.Entry entry : futures.entrySet()) {
                        this.keepLedgerMetadata((Long)entry.getKey(), (CompletableFuture)entry.getValue(), output, decodeMeta);
                    }
                    futures.clear();
                }
                for (Map.Entry e : futures.entrySet()) {
                    this.keepLedgerMetadata((Long)e.getKey(), (CompletableFuture)e.getValue(), output, decodeMeta);
                }
                futures.clear();
            } else {
                while (iter.hasNext()) {
                    LedgerManager.LedgerRange r = iter.next();
                    for (Long lid : r.getLedgers()) {
                        output.put(lid.toString(), null);
                    }
                }
            }
            manager.close();
            String jsonResponse = JsonUtil.toJson(output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

