/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.util.StringUtils;

public abstract class PacketProcessorBaseV3
extends SafeRunnable {
    final BookkeeperProtocol.Request request;
    final Channel channel;
    final BookieRequestProcessor requestProcessor;
    final long enqueueNanos;

    public PacketProcessorBaseV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.channel = channel;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponse(final BookkeeperProtocol.StatusCode code, Object response, final OpStatsLogger statsLogger) {
        final long writeNanos = MathUtils.nowInNano();
        long timeOut = this.requestProcessor.getWaitTimeoutOnBackpressureMillis();
        if (timeOut >= 0L && !this.channel.isWritable()) {
            if (!this.requestProcessor.isBlacklisted(this.channel)) {
                Channel channel = this.channel;
                synchronized (channel) {
                    if (!this.channel.isWritable() && !this.requestProcessor.isBlacklisted(this.channel)) {
                        long waitUntilNanos = writeNanos + TimeUnit.MILLISECONDS.toNanos(timeOut);
                        while (!this.channel.isWritable() && MathUtils.nowInNano() < waitUntilNanos) {
                            try {
                                TimeUnit.MILLISECONDS.sleep(1L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                                break;
                            }
                        }
                        if (!this.channel.isWritable()) {
                            this.requestProcessor.blacklistChannel(this.channel);
                            this.requestProcessor.handleNonWritableChannel(this.channel);
                        }
                    }
                }
            }
            if (!this.channel.isWritable()) {
                LOGGER.warn("cannot write response to non-writable channel {} for request {}", (Object)this.channel, (Object)StringUtils.requestToString(this.request));
                this.requestProcessor.getRequestStats().getChannelWriteStats().registerFailedEvent(MathUtils.elapsedNanos(writeNanos), TimeUnit.NANOSECONDS);
                statsLogger.registerFailedEvent(MathUtils.elapsedNanos(this.enqueueNanos), TimeUnit.NANOSECONDS);
                return;
            }
            this.requestProcessor.invalidateBlacklist(this.channel);
        }
        if (this.channel.isActive()) {
            this.channel.writeAndFlush(response).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    long writeElapsedNanos = MathUtils.elapsedNanos(writeNanos);
                    if (!future.isSuccess()) {
                        PacketProcessorBaseV3.this.requestProcessor.getRequestStats().getChannelWriteStats().registerFailedEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                    } else {
                        PacketProcessorBaseV3.this.requestProcessor.getRequestStats().getChannelWriteStats().registerSuccessfulEvent(writeElapsedNanos, TimeUnit.NANOSECONDS);
                    }
                    if (BookkeeperProtocol.StatusCode.EOK == code) {
                        statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos(PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                    } else {
                        statsLogger.registerFailedEvent(MathUtils.elapsedNanos(PacketProcessorBaseV3.this.enqueueNanos), TimeUnit.NANOSECONDS);
                    }
                }
            });
        } else {
            LOGGER.debug("Netty channel {} is inactive, hence bypassing netty channel writeAndFlush during sendResponse", (Object)this.channel);
        }
    }

    protected boolean isVersionCompatible() {
        return this.request.getHeader().getVersion().equals(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
    }

    protected BookkeeperProtocol.BKPacketHeader getHeader() {
        BookkeeperProtocol.BKPacketHeader.Builder header = BookkeeperProtocol.BKPacketHeader.newBuilder();
        header.setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE);
        header.setOperation(this.request.getHeader().getOperation());
        header.setTxnId(this.request.getHeader().getTxnId());
        return header.build();
    }

    public String toString() {
        return this.request.toString();
    }
}

