/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.shaded.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthHandler {
    static final Logger LOG = LoggerFactory.getLogger(AuthHandler.class);

    AuthHandler() {
    }

    static class AuthenticationException
    extends IOException {
        AuthenticationException(String reason) {
            super(reason);
        }
    }

    static class ClientSideHandler
    extends ChannelDuplexHandler {
        volatile boolean authenticated = false;
        final ClientAuthProvider.Factory authProviderFactory;
        ClientAuthProvider authProvider;
        final AtomicLong transactionIdGenerator;
        final Queue<Object> waitingForAuth = new ConcurrentLinkedQueue<Object>();
        final ClientConnectionPeer connectionPeer;
        private final boolean isUsingV2Protocol;

        public ClientAuthProvider getAuthProvider() {
            return this.authProvider;
        }

        ClientSideHandler(ClientAuthProvider.Factory authProviderFactory, AtomicLong transactionIdGenerator, ClientConnectionPeer connectionPeer, boolean isUsingV2Protocol) {
            this.authProviderFactory = authProviderFactory;
            this.transactionIdGenerator = transactionIdGenerator;
            this.connectionPeer = connectionPeer;
            this.authProvider = null;
            this.isUsingV2Protocol = isUsingV2Protocol;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.authProvider = this.authProviderFactory.newProvider(this.connectionPeer, new AuthHandshakeCompleteCallback(ctx));
            this.authProvider.init(new AuthRequestCallback(ctx, this.authProviderFactory.getPluginName()));
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.authProvider != null) {
                this.authProvider.close();
            }
            super.channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            assert (this.authProvider != null);
            if (this.authenticated) {
                super.channelRead(ctx, msg);
            } else if (msg instanceof BookkeeperProtocol.Response) {
                BookkeeperProtocol.Response resp = (BookkeeperProtocol.Response)msg;
                if (null == resp.getHeader().getOperation()) {
                    LOG.info("dropping received malformed message {} from bookie {}", msg, (Object)ctx.channel());
                } else {
                    switch (resp.getHeader().getOperation()) {
                        case START_TLS: {
                            super.channelRead(ctx, msg);
                            break;
                        }
                        case AUTH: {
                            if (resp.getStatus() != BookkeeperProtocol.StatusCode.EOK) {
                                this.authenticationError(ctx, resp.getStatus().getNumber());
                                break;
                            }
                            assert (resp.hasAuthResponse());
                            BookkeeperProtocol.AuthMessage am = resp.getAuthResponse();
                            if ("AuthDisabledPlugin".equals(am.getAuthPluginName())) {
                                SocketAddress remote = ctx.channel().remoteAddress();
                                LOG.info("Authentication is not enabled.Considering this client {} authenticated", (Object)remote);
                                AuthHandshakeCompleteCallback cb = new AuthHandshakeCompleteCallback(ctx);
                                cb.operationComplete(0, null);
                                return;
                            }
                            byte[] payload = am.getPayload().toByteArray();
                            this.authProvider.process(AuthToken.wrap(payload), new AuthRequestCallback(ctx, this.authProviderFactory.getPluginName()));
                            break;
                        }
                        default: {
                            LOG.warn("dropping received message {} from bookie {}", msg, (Object)ctx.channel());
                        }
                    }
                }
            } else if (msg instanceof BookieProtocol.Response) {
                BookieProtocol.Response resp = (BookieProtocol.Response)msg;
                switch (resp.opCode) {
                    case 3: {
                        if (resp.errorCode != 0) {
                            this.authenticationError(ctx, resp.errorCode);
                            break;
                        }
                        BookkeeperProtocol.AuthMessage am = ((BookieProtocol.AuthResponse)resp).authMessage;
                        if ("AuthDisabledPlugin".equals(am.getAuthPluginName())) {
                            SocketAddress remote = ctx.channel().remoteAddress();
                            LOG.info("Authentication is not enabled.Considering this client {} authenticated", (Object)remote);
                            AuthHandshakeCompleteCallback cb = new AuthHandshakeCompleteCallback(ctx);
                            cb.operationComplete(0, null);
                            return;
                        }
                        byte[] payload = am.getPayload().toByteArray();
                        this.authProvider.process(AuthToken.wrap(payload), new AuthRequestCallback(ctx, this.authProviderFactory.getPluginName()));
                        break;
                    }
                    default: {
                        LOG.warn("dropping received message {} from bookie {}", msg, (Object)ctx.channel());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            ClientSideHandler clientSideHandler = this;
            synchronized (clientSideHandler) {
                if (this.authenticated) {
                    super.write(ctx, msg, promise);
                    super.flush(ctx);
                } else if (msg instanceof BookkeeperProtocol.Request) {
                    BookkeeperProtocol.Request req = (BookkeeperProtocol.Request)msg;
                    if (req.getHeader().getOperation() == BookkeeperProtocol.OperationType.AUTH || req.getHeader().getOperation() == BookkeeperProtocol.OperationType.START_TLS) {
                        super.write(ctx, msg, promise);
                        super.flush(ctx);
                    } else {
                        this.waitingForAuth.add(msg);
                    }
                } else if (msg instanceof BookieProtocol.Request) {
                    BookieProtocol.Request req = (BookieProtocol.Request)msg;
                    if (3 == req.getOpCode()) {
                        super.write(ctx, msg, promise);
                        super.flush(ctx);
                    } else {
                        this.waitingForAuth.add(msg);
                    }
                } else {
                    LOG.info("dropping write of message {}", msg);
                }
            }
        }

        long newTxnId() {
            return this.transactionIdGenerator.incrementAndGet();
        }

        void authenticationError(ChannelHandlerContext ctx, int errorCode) {
            LOG.error("Error processing auth message, erroring connection {}", (Object)errorCode);
            ctx.fireExceptionCaught((Throwable)new AuthenticationException("Auth failed with error " + errorCode));
        }

        class AuthHandshakeCompleteCallback
        implements AuthCallbacks.GenericCallback<Void> {
            ChannelHandlerContext ctx;

            AuthHandshakeCompleteCallback(ChannelHandlerContext ctx) {
                this.ctx = ctx;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(int rc, Void v) {
                if (rc == 0) {
                    AuthHandshakeCompleteCallback authHandshakeCompleteCallback = this;
                    synchronized (authHandshakeCompleteCallback) {
                        ClientSideHandler.this.authenticated = true;
                        Object msg = ClientSideHandler.this.waitingForAuth.poll();
                        while (msg != null) {
                            this.ctx.writeAndFlush(msg);
                            msg = ClientSideHandler.this.waitingForAuth.poll();
                        }
                    }
                } else {
                    LOG.warn("Client authentication failed");
                    ClientSideHandler.this.authenticationError(this.ctx, rc);
                }
            }
        }

        class AuthRequestCallback
        implements AuthCallbacks.GenericCallback<AuthToken> {
            Channel channel;
            ChannelHandlerContext ctx;
            String pluginName;

            AuthRequestCallback(ChannelHandlerContext ctx, String pluginName) {
                this.channel = ctx.channel();
                this.ctx = ctx;
                this.pluginName = pluginName;
            }

            @Override
            public void operationComplete(int rc, AuthToken newam) {
                if (rc != 0) {
                    ClientSideHandler.this.authenticationError(this.ctx, rc);
                    return;
                }
                BookkeeperProtocol.AuthMessage message = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName(this.pluginName).setPayload(ByteString.copyFrom(newam.getData())).build();
                if (ClientSideHandler.this.isUsingV2Protocol) {
                    this.channel.writeAndFlush((Object)new BookieProtocol.AuthRequest(2, message), this.channel.voidPromise());
                } else {
                    BookkeeperProtocol.BKPacketHeader header = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.AUTH).setTxnId(ClientSideHandler.this.newTxnId()).build();
                    BookkeeperProtocol.Request.Builder builder = BookkeeperProtocol.Request.newBuilder().setHeader(header).setAuthRequest(message);
                    this.channel.writeAndFlush((Object)builder.build());
                }
            }
        }
    }

    static class ServerSideHandler
    extends ChannelInboundHandlerAdapter {
        volatile boolean authenticated = false;
        final BookieAuthProvider.Factory authProviderFactory;
        final BookieConnectionPeer connectionPeer;
        BookieAuthProvider authProvider;

        ServerSideHandler(BookieConnectionPeer connectionPeer, BookieAuthProvider.Factory authProviderFactory) {
            this.authProviderFactory = authProviderFactory;
            this.connectionPeer = connectionPeer;
            this.authProvider = null;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.authProvider = this.authProviderFactory.newProvider(this.connectionPeer, new AuthHandshakeCompleteCallback());
            super.channelActive(ctx);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (this.authProvider != null) {
                this.authProvider.close();
            }
            super.channelInactive(ctx);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (this.authProvider == null) {
                ctx.channel().close();
                return;
            }
            if (this.authenticated) {
                super.channelRead(ctx, msg);
            } else if (msg instanceof BookieProtocol.AuthRequest) {
                BookieProtocol.AuthRequest req = (BookieProtocol.AuthRequest)msg;
                assert (req.getOpCode() == 3);
                if (this.checkAuthPlugin(req.getAuthMessage(), ctx.channel())) {
                    byte[] payload = req.getAuthMessage().getPayload().toByteArray();
                    this.authProvider.process(AuthToken.wrap(payload), new AuthResponseCallbackLegacy(req, ctx.channel()));
                } else {
                    ctx.channel().close();
                }
            } else if (msg instanceof BookieProtocol.Request) {
                BookieProtocol.Request req = (BookieProtocol.Request)msg;
                if (req.getOpCode() == 1) {
                    ctx.channel().writeAndFlush((Object)BookieProtocol.AddResponse.create(req.getProtocolVersion(), 102, req.getLedgerId(), req.getEntryId()));
                } else if (req.getOpCode() == 2) {
                    ctx.channel().writeAndFlush((Object)new BookieProtocol.ReadResponse(req.getProtocolVersion(), 102, req.getLedgerId(), req.getEntryId()));
                } else {
                    ctx.channel().close();
                }
            } else if (msg instanceof BookkeeperProtocol.Request) {
                BookkeeperProtocol.Request req = (BookkeeperProtocol.Request)msg;
                if (req.getHeader().getOperation() == BookkeeperProtocol.OperationType.AUTH && req.hasAuthRequest() && this.checkAuthPlugin(req.getAuthRequest(), ctx.channel())) {
                    byte[] payload = req.getAuthRequest().getPayload().toByteArray();
                    this.authProvider.process(AuthToken.wrap(payload), new AuthResponseCallback(req, ctx.channel(), this.authProviderFactory.getPluginName()));
                } else if (req.getHeader().getOperation() == BookkeeperProtocol.OperationType.START_TLS && req.hasStartTLSRequest()) {
                    super.channelRead(ctx, msg);
                } else {
                    BookkeeperProtocol.Response.Builder builder = BookkeeperProtocol.Response.newBuilder().setHeader(req.getHeader()).setStatus(BookkeeperProtocol.StatusCode.EUA);
                    ctx.channel().writeAndFlush((Object)builder.build());
                }
            } else {
                ctx.channel().close();
            }
        }

        private boolean checkAuthPlugin(BookkeeperProtocol.AuthMessage am, Channel src) {
            if (!am.hasAuthPluginName() || !am.getAuthPluginName().equals(this.authProviderFactory.getPluginName())) {
                LOG.error("Received message from incompatible auth plugin. Local = {}, Remote = {}, Channel = {}", (Object)this.authProviderFactory.getPluginName(), (Object)am.getAuthPluginName());
                return false;
            }
            return true;
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        class AuthHandshakeCompleteCallback
        implements AuthCallbacks.GenericCallback<Void> {
            AuthHandshakeCompleteCallback() {
            }

            @Override
            public void operationComplete(int rc, Void v) {
                if (rc == 0) {
                    ServerSideHandler.this.authenticated = true;
                    LOG.info("Authentication success on server side");
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed on server side");
                }
            }
        }

        static class AuthResponseCallback
        implements AuthCallbacks.GenericCallback<AuthToken> {
            final BookkeeperProtocol.Request req;
            final Channel channel;
            final String pluginName;

            AuthResponseCallback(BookkeeperProtocol.Request req, Channel channel, String pluginName) {
                this.req = req;
                this.channel = channel;
                this.pluginName = pluginName;
            }

            @Override
            public void operationComplete(int rc, AuthToken newam) {
                BookkeeperProtocol.Response.Builder builder = BookkeeperProtocol.Response.newBuilder().setHeader(this.req.getHeader());
                if (rc != 0) {
                    LOG.error("Error processing auth message, closing connection");
                    builder.setStatus(BookkeeperProtocol.StatusCode.EUA);
                    this.channel.writeAndFlush((Object)builder.build());
                    this.channel.close();
                    return;
                }
                BookkeeperProtocol.AuthMessage message = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName(this.pluginName).setPayload(ByteString.copyFrom(newam.getData())).build();
                builder.setStatus(BookkeeperProtocol.StatusCode.EOK).setAuthResponse(message);
                this.channel.writeAndFlush((Object)builder.build());
            }
        }

        static class AuthResponseCallbackLegacy
        implements AuthCallbacks.GenericCallback<AuthToken> {
            final BookieProtocol.AuthRequest req;
            final Channel channel;

            AuthResponseCallbackLegacy(BookieProtocol.AuthRequest req, Channel channel) {
                this.req = req;
                this.channel = channel;
            }

            @Override
            public void operationComplete(int rc, AuthToken newam) {
                if (rc != 0) {
                    LOG.error("Error processing auth message, closing connection");
                    this.channel.close();
                    return;
                }
                BookkeeperProtocol.AuthMessage message = BookkeeperProtocol.AuthMessage.newBuilder().setAuthPluginName(this.req.authMessage.getAuthPluginName()).setPayload(ByteString.copyFrom(newam.getData())).build();
                this.channel.writeAndFlush((Object)new BookieProtocol.AuthResponse(this.req.getProtocolVersion(), message));
            }
        }
    }
}

