/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.PendingAddOp;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerHandleAdv
extends LedgerHandle
implements WriteAdvHandle {
    static final Logger LOG = LoggerFactory.getLogger(LedgerHandleAdv.class);

    LedgerHandleAdv(ClientContext clientCtx, long ledgerId, Versioned<LedgerMetadata> metadata, BookKeeper.DigestType digestType, byte[] password, EnumSet<WriteFlag> writeFlags) throws GeneralSecurityException, NumberFormatException {
        super(clientCtx, ledgerId, metadata, digestType, password, writeFlags);
        this.pendingAddOps = new PriorityBlockingQueue<PendingAddOp>(10, new PendingOpsComparator());
    }

    @Override
    public long addEntry(long entryId, byte[] data) throws InterruptedException, BKException {
        return this.addEntry(entryId, data, 0, data.length);
    }

    @Override
    public long addEntry(long entryId, byte[] data, int offset, int length) throws InterruptedException, BKException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding entry {}", (Object)data);
        }
        SyncCallbackUtils.SyncAddCallback callback = new SyncCallbackUtils.SyncAddCallback();
        this.asyncAddEntry(entryId, data, offset, length, callback, null);
        try {
            return (Long)callback.get();
        }
        catch (ExecutionException err) {
            throw (BKException)err.getCause();
        }
    }

    @Override
    public void asyncAddEntry(long entryId, byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(entryId, data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(long entryId, byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(entryId, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), (AsyncCallback.AddCallbackWithLatency)cb, ctx);
    }

    @Override
    public void asyncAddEntry(long entryId, byte[] data, int offset, int length, AsyncCallback.AddCallbackWithLatency cb, Object ctx) {
        this.asyncAddEntry(entryId, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), cb, ctx);
    }

    @Override
    public void asyncAddEntry(long entryId, ByteBuf data, AsyncCallback.AddCallbackWithLatency cb, Object ctx) {
        PendingAddOp op = PendingAddOp.create(this, this.clientCtx, this.getCurrentEnsemble(), data, this.writeFlags, cb, ctx);
        op.setEntryId(entryId);
        if (entryId <= this.lastAddConfirmed || this.pendingAddOps.contains(op)) {
            LOG.error("Trying to re-add duplicate entryid:{}", (Object)entryId);
            op.submitCallback(-22);
            return;
        }
        this.doAsyncAddEntry(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAsyncAddEntry(final PendingAddOp op) {
        if (this.throttler != null) {
            this.throttler.acquire();
        }
        boolean wasClosed = false;
        LedgerHandleAdv ledgerHandleAdv = this;
        synchronized (ledgerHandleAdv) {
            if (this.isHandleWritable()) {
                long currentLength = this.addToLength(op.payload.readableBytes());
                op.setLedgerLength(currentLength);
                this.pendingAddOps.add(op);
            } else {
                wasClosed = true;
            }
        }
        if (wasClosed) {
            try {
                this.clientCtx.getMainWorkerPool().submit(new org.apache.bookkeeper.util.SafeRunnable(){

                    @Override
                    public void safeRun() {
                        LOG.warn("Attempt to add to closed ledger: {}", (Object)LedgerHandleAdv.this.ledgerId);
                        op.cb.addCompleteWithLatency(-11, LedgerHandleAdv.this, op.getEntryId(), 0L, op.ctx);
                    }

                    public String toString() {
                        return String.format("AsyncAddEntryToClosedLedger(lid=%d)", LedgerHandleAdv.this.ledgerId);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                op.cb.addCompleteWithLatency(BookKeeper.getReturnRc(this.clientCtx.getBookieClient(), -15), this, op.getEntryId(), 0L, op.ctx);
            }
            return;
        }
        if (!this.waitForWritable(this.distributionSchedule.getWriteSet(op.getEntryId()), 0, this.clientCtx.getConf().waitForWriteSetMs)) {
            op.allowFailFastOnUnwritableChannel();
        }
        try {
            this.clientCtx.getMainWorkerPool().executeOrdered(this.ledgerId, (SafeRunnable)op);
        }
        catch (RejectedExecutionException e) {
            op.cb.addCompleteWithLatency(BookKeeper.getReturnRc(this.clientCtx.getBookieClient(), -15), this, op.getEntryId(), 0L, op.ctx);
        }
    }

    @Override
    public CompletableFuture<Long> writeAsync(long entryId, ByteBuf data) {
        SyncCallbackUtils.SyncAddCallback callback = new SyncCallbackUtils.SyncAddCallback();
        this.asyncAddEntry(entryId, data, (AsyncCallback.AddCallbackWithLatency)callback, (Object)data);
        return callback;
    }

    @Override
    public void asyncAddEntry(ByteBuf data, AsyncCallback.AddCallback cb, Object ctx) {
        cb.addCompleteWithLatency(-100, this, -1L, 0L, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        cb.addComplete(-100, this, -1L, ctx);
    }

    static class PendingOpsComparator
    implements Comparator<PendingAddOp>,
    Serializable {
        PendingOpsComparator() {
        }

        @Override
        public int compare(PendingAddOp o1, PendingAddOp o2) {
            return Long.compare(o1.entryId, o2.entryId);
        }
    }
}

