/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncThread
implements Checkpointer {
    private static final Logger log = LoggerFactory.getLogger(SyncThread.class);
    final ScheduledExecutorService executor;
    final LedgerStorage ledgerStorage;
    final LedgerDirsManager.LedgerDirsListener dirsListener;
    final CheckpointSource checkpointSource;
    private final Object suspensionLock = new Object();
    private boolean suspended = false;
    private boolean disableCheckpoint = false;

    public SyncThread(ServerConfiguration conf, LedgerDirsManager.LedgerDirsListener dirsListener, LedgerStorage ledgerStorage, CheckpointSource checkpointSource) {
        this.dirsListener = dirsListener;
        this.ledgerStorage = ledgerStorage;
        this.checkpointSource = checkpointSource;
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("SyncThread"));
    }

    @Override
    public void startCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        this.doCheckpoint(checkpoint);
    }

    protected void doCheckpoint(CheckpointSource.Checkpoint checkpoint) {
        this.executor.submit(() -> {
            try {
                Object object = this.suspensionLock;
                synchronized (object) {
                    while (this.suspended) {
                        try {
                            this.suspensionLock.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                if (!this.disableCheckpoint) {
                    this.checkpoint(checkpoint);
                }
            }
            catch (Throwable t) {
                log.error("Exception in SyncThread", t);
                this.dirsListener.fatalError();
            }
        });
    }

    public Future requestFlush() {
        return this.executor.submit(() -> {
            try {
                this.flush();
            }
            catch (Throwable t) {
                log.error("Exception flushing ledgers ", t);
            }
        });
    }

    private void flush() {
        CheckpointSource.Checkpoint checkpoint = this.checkpointSource.newCheckpoint();
        try {
            this.ledgerStorage.flush();
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            log.error("No writeable ledger directories", (Throwable)e);
            this.dirsListener.allDisksFull(true);
            return;
        }
        catch (IOException e) {
            log.error("Exception flushing ledgers", (Throwable)e);
            return;
        }
        if (this.disableCheckpoint) {
            return;
        }
        log.info("Flush ledger storage at checkpoint {}.", (Object)checkpoint);
        try {
            this.checkpointSource.checkpointComplete(checkpoint, false);
        }
        catch (IOException e) {
            log.error("Exception marking checkpoint as complete", (Throwable)e);
            this.dirsListener.allDisksFull(true);
        }
    }

    @VisibleForTesting
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) {
        if (null == checkpoint) {
            return;
        }
        try {
            this.ledgerStorage.checkpoint(checkpoint);
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException e) {
            log.error("No writeable ledger directories", (Throwable)e);
            this.dirsListener.allDisksFull(true);
            return;
        }
        catch (IOException e) {
            log.error("Exception flushing ledgers", (Throwable)e);
            return;
        }
        try {
            this.checkpointSource.checkpointComplete(checkpoint, true);
        }
        catch (IOException e) {
            log.error("Exception marking checkpoint as complete", (Throwable)e);
            this.dirsListener.allDisksFull(true);
        }
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void suspendSync() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void resumeSync() {
        Object object = this.suspensionLock;
        synchronized (object) {
            this.suspended = false;
            this.suspensionLock.notify();
        }
    }

    @VisibleForTesting
    public void disableCheckpoint() {
        this.disableCheckpoint = true;
    }

    void shutdown() throws InterruptedException {
        log.info("Shutting down SyncThread");
        this.requestFlush();
        this.executor.shutdown();
        long start = System.currentTimeMillis();
        while (!this.executor.awaitTermination(5L, TimeUnit.MINUTES)) {
            long now = System.currentTimeMillis();
            log.info("SyncThread taking a long time to shutdown. Has taken {} milliseconds so far", (Object)(now - start));
        }
    }

    ScheduledExecutorService getExecutor() {
        return this.executor;
    }
}

