/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.PrimitiveIterator;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDescriptorImpl;
import org.apache.bookkeeper.bookie.LedgerDescriptorReadOnlyImpl;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.SettableFuture;

public abstract class LedgerDescriptor {
    static LedgerDescriptor create(byte[] masterKey, long ledgerId, LedgerStorage ledgerStorage) throws IOException {
        LedgerDescriptorImpl ledger = new LedgerDescriptorImpl(masterKey, ledgerId, ledgerStorage);
        ledgerStorage.setMasterKey(ledgerId, masterKey);
        return ledger;
    }

    static LedgerDescriptor createReadOnly(long ledgerId, LedgerStorage ledgerStorage) throws IOException, Bookie.NoLedgerException {
        if (!ledgerStorage.ledgerExists(ledgerId)) {
            throw new Bookie.NoLedgerException(ledgerId);
        }
        return new LedgerDescriptorReadOnlyImpl(ledgerId, ledgerStorage);
    }

    static ByteBuf createLedgerFenceEntry(Long ledgerId) {
        ByteBuf bb = Unpooled.buffer((int)16);
        bb.writeLong(ledgerId.longValue());
        bb.writeLong(-8192L);
        return bb;
    }

    abstract void checkAccess(byte[] var1) throws BookieException, IOException;

    abstract long getLedgerId();

    abstract boolean setFenced() throws IOException;

    abstract boolean isFenced() throws IOException;

    abstract SettableFuture<Boolean> fenceAndLogInJournal(Journal var1) throws IOException;

    abstract long addEntry(ByteBuf var1) throws IOException, BookieException;

    abstract ByteBuf readEntry(long var1) throws IOException;

    abstract long getLastAddConfirmed() throws IOException;

    abstract boolean waitForLastAddConfirmedUpdate(long var1, Watcher<LastAddConfirmedUpdateNotification> var3) throws IOException;

    abstract void cancelWaitForLastAddConfirmedUpdate(Watcher<LastAddConfirmedUpdateNotification> var1) throws IOException;

    abstract void setExplicitLac(ByteBuf var1) throws IOException;

    abstract ByteBuf getExplicitLac() throws IOException;

    abstract PrimitiveIterator.OfLong getListOfEntriesOfLedger(long var1) throws IOException;
}

