/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.bookkeeper.bookie.EntryLogManager;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.EntryLoggerAllocator;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class EntryLogManagerBase
implements EntryLogManager {
    private static final Logger log = LoggerFactory.getLogger(EntryLogManagerBase.class);
    volatile List<EntryLogger.BufferedLogChannel> rotatedLogChannels;
    final EntryLoggerAllocator entryLoggerAllocator;
    final LedgerDirsManager ledgerDirsManager;
    private final List<EntryLogger.EntryLogListener> listeners;
    final long logSizeLimit;
    private final FastThreadLocal<ByteBuf> sizeBufferForAdd = new FastThreadLocal<ByteBuf>(){

        protected ByteBuf initialValue() throws Exception {
            return Unpooled.buffer((int)4);
        }
    };

    EntryLogManagerBase(ServerConfiguration conf, LedgerDirsManager ledgerDirsManager, EntryLoggerAllocator entryLoggerAllocator, List<EntryLogger.EntryLogListener> listeners) {
        this.ledgerDirsManager = ledgerDirsManager;
        this.entryLoggerAllocator = entryLoggerAllocator;
        this.listeners = listeners;
        this.logSizeLimit = conf.getEntryLogSizeLimit();
    }

    @Override
    public long addEntry(long ledger, ByteBuf entry, boolean rollLog) throws IOException {
        int entrySize = entry.readableBytes() + 4;
        EntryLogger.BufferedLogChannel logChannel = this.getCurrentLogForLedgerForAddEntry(ledger, entrySize, rollLog);
        ByteBuf sizeBuffer = (ByteBuf)this.sizeBufferForAdd.get();
        sizeBuffer.clear();
        sizeBuffer.writeInt(entry.readableBytes());
        logChannel.write(sizeBuffer);
        long pos = logChannel.position();
        logChannel.write(entry);
        logChannel.registerWrittenEntry(ledger, entrySize);
        return logChannel.getLogId() << 32 | pos;
    }

    boolean reachEntryLogLimit(EntryLogger.BufferedLogChannel logChannel, long size) {
        if (logChannel == null) {
            return false;
        }
        return logChannel.position() + size > this.logSizeLimit;
    }

    boolean readEntryLogHardLimit(EntryLogger.BufferedLogChannel logChannel, long size) {
        if (logChannel == null) {
            return false;
        }
        return logChannel.position() + size > Integer.MAX_VALUE;
    }

    abstract EntryLogger.BufferedLogChannel getCurrentLogForLedger(long var1) throws IOException;

    abstract EntryLogger.BufferedLogChannel getCurrentLogForLedgerForAddEntry(long var1, int var3, boolean var4) throws IOException;

    abstract void setCurrentLogForLedgerAndAddToRotate(long var1, EntryLogger.BufferedLogChannel var3) throws IOException;

    abstract void flushCurrentLogs() throws IOException;

    abstract void flushRotatedLogs() throws IOException;

    List<EntryLogger.BufferedLogChannel> getRotatedLogChannels() {
        return this.rotatedLogChannels;
    }

    @Override
    public void flush() throws IOException {
        this.flushCurrentLogs();
        this.flushRotatedLogs();
    }

    void flushLogChannel(EntryLogger.BufferedLogChannel logChannel, boolean forceMetadata) throws IOException {
        if (logChannel != null) {
            logChannel.flushAndForceWrite(forceMetadata);
            log.debug("Flush and sync current entry logger {}", (Object)logChannel.getLogId());
        }
    }

    @VisibleForTesting
    void createNewLog(long ledgerId) throws IOException {
        this.createNewLog(ledgerId, "");
    }

    void createNewLog(long ledgerId, String reason) throws IOException {
        if (ledgerId != -1L) {
            log.info("Creating a new entry log file for ledger '{}' {}", (Object)ledgerId, (Object)reason);
        } else {
            log.info("Creating a new entry log file {}", (Object)reason);
        }
        EntryLogger.BufferedLogChannel logChannel = this.getCurrentLogForLedger(ledgerId);
        if (null != logChannel) {
            logChannel.flush();
            logChannel.appendLedgersMap();
            EntryLogger.BufferedLogChannel newLogChannel = this.entryLoggerAllocator.createNewLog(this.selectDirForNextEntryLog());
            this.setCurrentLogForLedgerAndAddToRotate(ledgerId, newLogChannel);
            log.info("Flushing entry logger {} back to filesystem, pending for syncing entry loggers : {}.", (Object)logChannel.getLogId(), this.rotatedLogChannels);
            for (EntryLogger.EntryLogListener listener : this.listeners) {
                listener.onRotateEntryLog();
            }
        } else {
            this.setCurrentLogForLedgerAndAddToRotate(ledgerId, this.entryLoggerAllocator.createNewLog(this.selectDirForNextEntryLog()));
        }
    }

    File selectDirForNextEntryLog() throws LedgerDirsManager.NoWritableLedgerDirException {
        return this.getDirForNextEntryLog(this.ledgerDirsManager.getWritableLedgerDirsForNewLog());
    }
}

