/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.BookieStatus;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.bookkeeper.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.annotations.StatsDoc;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StatsDoc(name="bookie", category="server", help="Bookie state manager related stats")
public class BookieStateManager
implements StateManager {
    private static final Logger log = LoggerFactory.getLogger(BookieStateManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(BookieStateManager.class);
    private final ServerConfiguration conf;
    private final Supplier<BookieServiceInfo> bookieServiceInfoProvider;
    private final List<File> statusDirs;
    final ExecutorService stateService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("BookieStateManagerService-%d").build());
    private volatile boolean running = false;
    private volatile boolean shuttingdown = false;
    private final BookieStatus bookieStatus = new BookieStatus();
    private final AtomicBoolean rmRegistered = new AtomicBoolean(false);
    private final AtomicBoolean forceReadOnly = new AtomicBoolean(false);
    private volatile boolean availableForHighPriorityWrites = true;
    private final BookieId bookieId;
    private StateManager.ShutdownHandler shutdownHandler;
    private final Supplier<RegistrationManager> rm;
    @StatsDoc(name="SERVER_STATUS", help="Bookie status (1: up, 0: readonly, -1: unregistered)")
    private final Gauge<Number> serverStatusGauge;

    public BookieStateManager(ServerConfiguration conf, StatsLogger statsLogger, MetadataBookieDriver metadataDriver, LedgerDirsManager ledgerDirsManager, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException {
        this(conf, statsLogger, () -> null == metadataDriver ? null : metadataDriver.getRegistrationManager(), ledgerDirsManager.getAllLedgerDirs(), () -> {
            try {
                return Bookie.getBookieId(conf);
            }
            catch (UnknownHostException e) {
                throw new UncheckedIOException("Failed to resolve bookie id", e);
            }
        }, bookieServiceInfoProvider);
    }

    public BookieStateManager(ServerConfiguration conf, StatsLogger statsLogger, Supplier<RegistrationManager> rm, List<File> statusDirs, Supplier<BookieId> bookieIdSupplier, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws IOException {
        this.conf = conf;
        this.rm = rm;
        this.statusDirs = statusDirs;
        this.bookieId = bookieIdSupplier.get();
        this.bookieServiceInfoProvider = bookieServiceInfoProvider;
        this.serverStatusGauge = new Gauge<Number>(){

            public Number getDefaultValue() {
                return 0;
            }

            public Number getSample() {
                if (!BookieStateManager.this.rmRegistered.get()) {
                    return -1;
                }
                if (BookieStateManager.this.forceReadOnly.get() || BookieStateManager.this.bookieStatus.isInReadOnlyMode()) {
                    return 0;
                }
                return 1;
            }
        };
        statsLogger.registerGauge("SERVER_STATUS", this.serverStatusGauge);
    }

    private boolean isRegistrationManagerDisabled() {
        return null == this.rm || null == this.rm.get();
    }

    @VisibleForTesting
    BookieStateManager(ServerConfiguration conf, MetadataBookieDriver metadataDriver) throws IOException {
        this(conf, (StatsLogger)NullStatsLogger.INSTANCE, metadataDriver, new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()), (StatsLogger)NullStatsLogger.INSTANCE), BookieServiceInfo.NO_INFO);
    }

    @Override
    public void initState() {
        if (this.forceReadOnly.get()) {
            this.bookieStatus.setToReadOnlyMode();
        } else if (this.conf.isPersistBookieStatusEnabled()) {
            this.bookieStatus.readFromDirectories(this.statusDirs);
        }
        this.running = true;
    }

    @Override
    public void forceToShuttingDown() {
        this.shuttingdown = true;
    }

    @Override
    public void forceToReadOnly() {
        this.forceReadOnly.set(true);
    }

    @Override
    public void forceToUnregistered() {
        this.rmRegistered.set(false);
    }

    @Override
    public boolean isReadOnly() {
        return this.forceReadOnly.get() || this.bookieStatus.isInReadOnlyMode();
    }

    @Override
    public boolean isAvailableForHighPriorityWrites() {
        return this.availableForHighPriorityWrites;
    }

    @Override
    public void setHighPriorityWritesAvailability(boolean available) {
        if (this.availableForHighPriorityWrites && !available) {
            log.info("Disable high priority writes on readonly bookie.");
        } else if (!this.availableForHighPriorityWrites && available) {
            log.info("Enable high priority writes on readonly bookie.");
        }
        this.availableForHighPriorityWrites = available;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isShuttingDown() {
        return this.shuttingdown;
    }

    @Override
    public void close() {
        this.running = false;
        this.stateService.shutdown();
    }

    @Override
    public Future<Void> registerBookie(final boolean throwException) {
        return this.stateService.submit(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    BookieStateManager.this.doRegisterBookie();
                }
                catch (IOException ioe) {
                    if (throwException) {
                        throw ioe;
                    }
                    LOG.error("Couldn't register bookie with zookeeper, shutting down : ", (Throwable)ioe);
                    BookieStateManager.this.shutdownHandler.shutdown(4);
                }
                return null;
            }
        });
    }

    @Override
    public Future<Void> transitionToWritableMode() {
        return this.stateService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BookieStateManager.this.doTransitionToWritableMode();
                return null;
            }
        });
    }

    @Override
    public Future<Void> transitionToReadOnlyMode() {
        return this.stateService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BookieStateManager.this.doTransitionToReadOnlyMode();
                return null;
            }
        });
    }

    void doRegisterBookie() throws IOException {
        this.doRegisterBookie(this.forceReadOnly.get() || this.bookieStatus.isInReadOnlyMode());
    }

    private void doRegisterBookie(boolean isReadOnly) throws IOException {
        if (this.isRegistrationManagerDisabled()) {
            LOG.info("null registration manager while do register");
            return;
        }
        this.rmRegistered.set(false);
        try {
            this.rm.get().registerBookie(this.bookieId, isReadOnly, this.bookieServiceInfoProvider.get());
            this.rmRegistered.set(true);
        }
        catch (BookieException e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    public void doTransitionToWritableMode() {
        if (this.shuttingdown || this.forceReadOnly.get()) {
            return;
        }
        if (!this.bookieStatus.setToWritableMode()) {
            return;
        }
        LOG.info("Transitioning Bookie to Writable mode and will serve read/write requests.");
        if (this.conf.isPersistBookieStatusEnabled()) {
            this.bookieStatus.writeToDirectories(this.statusDirs);
        }
        if (this.isRegistrationManagerDisabled()) {
            return;
        }
        try {
            this.doRegisterBookie(false);
        }
        catch (IOException e) {
            LOG.warn("Error in transitioning back to writable mode : ", (Throwable)e);
            this.transitionToReadOnlyMode();
            return;
        }
        try {
            this.rm.get().unregisterBookie(this.bookieId, true);
        }
        catch (BookieException e) {
            LOG.warn("Failed to delete bookie readonly state in zookeeper : ", (Throwable)e);
            return;
        }
    }

    @VisibleForTesting
    public void doTransitionToReadOnlyMode() {
        if (this.shuttingdown) {
            return;
        }
        if (!this.bookieStatus.setToReadOnlyMode()) {
            return;
        }
        if (!this.conf.isReadOnlyModeEnabled()) {
            LOG.warn("ReadOnly mode is not enabled. Can be enabled by configuring 'readOnlyModeEnabled=true' in configuration. Shutting down bookie");
            this.shutdownHandler.shutdown(5);
            return;
        }
        LOG.info("Transitioning Bookie to ReadOnly mode, and will serve only read requests from clients!");
        if (this.conf.isPersistBookieStatusEnabled()) {
            this.bookieStatus.writeToDirectories(this.statusDirs);
        }
        if (this.isRegistrationManagerDisabled()) {
            return;
        }
        try {
            this.rm.get().registerBookie(this.bookieId, true, this.bookieServiceInfoProvider.get());
        }
        catch (BookieException e) {
            LOG.error("Error in transition to ReadOnly Mode. Shutting down", (Throwable)e);
            this.shutdownHandler.shutdown(5);
            return;
        }
    }

    @Override
    public void setShutdownHandler(StateManager.ShutdownHandler handler) {
        this.shutdownHandler = handler;
    }

    @VisibleForTesting
    public StateManager.ShutdownHandler getShutdownHandler() {
        return this.shutdownHandler;
    }

    @VisibleForTesting
    boolean isRegistered() {
        return this.rmRegistered.get();
    }
}

