/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.impl.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.common.util.PermitManager;
import org.apache.distributedlog.common.util.SchedulerUtils;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.InvalidStreamNameException;
import org.apache.distributedlog.exceptions.LockCancelledException;
import org.apache.distributedlog.exceptions.LockingException;
import org.apache.distributedlog.exceptions.LogExistsException;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.impl.ZKLogSegmentMetadataStore;
import org.apache.distributedlog.lock.DistributedLock;
import org.apache.distributedlog.lock.SessionLockFactory;
import org.apache.distributedlog.lock.ZKDistributedLock;
import org.apache.distributedlog.lock.ZKSessionLockFactory;
import org.apache.distributedlog.logsegment.LogSegmentMetadataStore;
import org.apache.distributedlog.metadata.LogMetadata;
import org.apache.distributedlog.metadata.LogMetadataForReader;
import org.apache.distributedlog.metadata.LogMetadataForWriter;
import org.apache.distributedlog.metadata.LogStreamMetadataStore;
import org.apache.distributedlog.util.DLUtils;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.distributedlog.zk.LimitedPermitManager;
import org.apache.distributedlog.zk.ZKTransaction;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.ZKUtil;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.common.PathUtils;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKLogStreamMetadataStore
implements LogStreamMetadataStore {
    private static final Logger LOG = LoggerFactory.getLogger(ZKLogStreamMetadataStore.class);
    private final String clientId;
    private final DistributedLogConfiguration conf;
    private final ZooKeeperClient zooKeeperClient;
    private final OrderedScheduler scheduler;
    private final StatsLogger statsLogger;
    private final LogSegmentMetadataStore logSegmentStore;
    private final LimitedPermitManager permitManager;
    private SessionLockFactory lockFactory;
    private OrderedScheduler lockStateExecutor;

    public ZKLogStreamMetadataStore(String clientId, DistributedLogConfiguration conf, ZooKeeperClient zkc, OrderedScheduler scheduler, StatsLogger statsLogger) {
        this.clientId = clientId;
        this.conf = conf;
        this.zooKeeperClient = zkc;
        this.scheduler = scheduler;
        this.statsLogger = statsLogger;
        this.logSegmentStore = new ZKLogSegmentMetadataStore(conf, this.zooKeeperClient, scheduler);
        this.permitManager = new LimitedPermitManager(conf.getLogSegmentRollingConcurrency(), 1, TimeUnit.MINUTES, (ScheduledExecutorService)scheduler);
        this.zooKeeperClient.register(this.permitManager);
    }

    private synchronized OrderedScheduler getLockStateExecutor(boolean createIfNull) {
        if (createIfNull && null == this.lockStateExecutor) {
            this.lockStateExecutor = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("DLM-LockState").numThreads(this.conf.getNumLockStateThreads()).build();
        }
        return this.lockStateExecutor;
    }

    private synchronized SessionLockFactory getLockFactory(boolean createIfNull) {
        if (createIfNull && null == this.lockFactory) {
            this.lockFactory = new ZKSessionLockFactory(this.zooKeeperClient, this.clientId, this.getLockStateExecutor(createIfNull), this.conf.getZKNumRetries(), this.conf.getLockTimeoutMilliSeconds(), this.conf.getZKRetryBackoffStartMillis(), this.statsLogger);
        }
        return this.lockFactory;
    }

    @Override
    public void close() throws IOException {
        this.zooKeeperClient.unregister(this.permitManager);
        this.permitManager.close();
        this.logSegmentStore.close();
        SchedulerUtils.shutdownScheduler((ExecutorService)this.getLockStateExecutor(false), (long)this.conf.getSchedulerShutdownTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    @Override
    public LogSegmentMetadataStore getLogSegmentMetadataStore() {
        return this.logSegmentStore;
    }

    @Override
    public PermitManager getPermitManager() {
        return this.permitManager;
    }

    @Override
    public Transaction<Object> newTransaction() {
        return new ZKTransaction(this.zooKeeperClient);
    }

    @Override
    public CompletableFuture<Void> logExists(URI uri, final String logName) {
        final String logSegmentsPath = LogMetadata.getLogSegmentsPath(uri, logName, this.conf.getUnpartitionedStreamName());
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        try {
            final ZooKeeper zk = this.zooKeeperClient.get();
            zk.sync(logSegmentsPath, new AsyncCallback.VoidCallback(){

                public void processResult(int syncRc, String path, Object syncCtx) {
                    if (KeeperException.Code.NONODE.intValue() == syncRc) {
                        promise.completeExceptionally(new LogNotFoundException(String.format("Log %s does not exist or has been deleted", logName)));
                        return;
                    }
                    if (KeeperException.Code.OK.intValue() != syncRc) {
                        promise.completeExceptionally((Throwable)((Object)new ZKException("Error on checking log existence for " + logName, KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)syncRc)))));
                        return;
                    }
                    zk.exists(logSegmentsPath, false, new AsyncCallback.StatCallback(){

                        public void processResult(int rc, String path, Object ctx, Stat stat) {
                            if (KeeperException.Code.OK.intValue() == rc) {
                                promise.complete(null);
                            } else if (KeeperException.Code.NONODE.intValue() == rc) {
                                promise.completeExceptionally(new LogNotFoundException(String.format("Log %s does not exist or has been deleted", logName)));
                            } else {
                                promise.completeExceptionally((Throwable)((Object)new ZKException("Error on checking log existence for " + logName, KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)))));
                            }
                        }
                    }, null);
                }
            }, null);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while reading {}", (Object)logSegmentsPath, (Object)ie);
            promise.completeExceptionally(new DLInterruptedException("Interrupted while checking " + logSegmentsPath, (Throwable)ie));
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            promise.completeExceptionally(e);
        }
        return promise;
    }

    @Override
    public DistributedLock createWriteLock(LogMetadataForWriter metadata) {
        return new ZKDistributedLock(this.getLockStateExecutor(true), this.getLockFactory(true), metadata.getLockPath(), this.conf.getLockTimeoutMilliSeconds(), this.statsLogger);
    }

    private CompletableFuture<Void> ensureReadLockPathExist(final LogMetadata logMetadata, String readLockPath) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        promise.whenComplete((value, cause) -> {
            if (cause instanceof CancellationException) {
                FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new LockCancelledException(readLockPath, "Could not ensure read lock path", cause));
            }
        });
        Optional<String> parentPathShouldNotCreate = Optional.of(logMetadata.getLogRootPath());
        Utils.zkAsyncCreateFullPathOptimisticRecursive(this.zooKeeperClient, readLockPath, parentPathShouldNotCreate, new byte[0], this.zooKeeperClient.getDefaultACL(), CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                if (KeeperException.Code.NONODE.intValue() == rc) {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new LogNotFoundException(String.format("Log %s does not exist or has been deleted", logMetadata.getFullyQualifiedName())));
                } else if (KeeperException.Code.OK.intValue() == rc) {
                    FutureUtils.complete((CompletableFuture)promise, null);
                    LOG.trace("Created path {}.", (Object)path);
                } else if (KeeperException.Code.NODEEXISTS.intValue() == rc) {
                    FutureUtils.complete((CompletableFuture)promise, null);
                    LOG.trace("Path {} is already existed.", (Object)path);
                } else if (-2147483646 == rc) {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new ZooKeeperClient.ZooKeeperConnectionException(path));
                } else if (-2147483647 == rc) {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)new DLInterruptedException(path));
                } else {
                    FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }
        }, null);
        return promise;
    }

    @Override
    public CompletableFuture<DistributedLock> createReadLock(LogMetadataForReader metadata, Optional<String> readerId) {
        String readLockPath = metadata.getReadLockPath(readerId);
        return this.ensureReadLockPathExist(metadata, readLockPath).thenApplyAsync(value -> {
            ZKDistributedLock lock = new ZKDistributedLock(this.getLockStateExecutor(true), this.getLockFactory(true), readLockPath, this.conf.getLockTimeoutMilliSeconds(), this.statsLogger.scope("read_lock"));
            return lock;
        }, (Executor)this.scheduler.chooseThread((Object)readLockPath));
    }

    static int bytesToInt(byte[] b) {
        assert (b.length >= 4);
        return b[0] << 24 | b[1] << 16 | b[2] << 8 | b[3];
    }

    static byte[] intToBytes(int i) {
        return new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
    }

    static CompletableFuture<List<Versioned<byte[]>>> checkLogMetadataPaths(ZooKeeper zk, String logRootPath, boolean ownAllocator) {
        String logRootParentPath = Utils.getParent(logRootPath);
        String logSegmentsPath = logRootPath + "/ledgers";
        String maxTxIdPath = logRootPath + "/maxtxid";
        String lockPath = logRootPath + "/lock";
        String readLockPath = logRootPath + "/readLock";
        String versionPath = logRootPath + "/version";
        String allocationPath = logRootPath + "/allocation";
        int numPaths = ownAllocator ? 8 : 7;
        ArrayList checkFutures = Lists.newArrayListWithExpectedSize((int)numPaths);
        checkFutures.add(Utils.zkGetData(zk, logRootParentPath, false));
        checkFutures.add(Utils.zkGetData(zk, logRootPath, false));
        checkFutures.add(Utils.zkGetData(zk, maxTxIdPath, false));
        checkFutures.add(Utils.zkGetData(zk, versionPath, false));
        checkFutures.add(Utils.zkGetData(zk, lockPath, false));
        checkFutures.add(Utils.zkGetData(zk, readLockPath, false));
        checkFutures.add(Utils.zkGetData(zk, logSegmentsPath, false));
        if (ownAllocator) {
            checkFutures.add(Utils.zkGetData(zk, allocationPath, false));
        }
        return FutureUtils.collect((List)checkFutures);
    }

    static boolean pathExists(Versioned<byte[]> metadata) {
        return null != metadata.getValue() && null != metadata.getVersion();
    }

    static void ensureMetadataExist(Versioned<byte[]> metadata) {
        Preconditions.checkNotNull((Object)metadata.getValue());
        Preconditions.checkNotNull((Object)metadata.getVersion());
    }

    static void createMissingMetadata(final ZooKeeper zk, String basePath, final String logRootPath, final List<Versioned<byte[]>> metadatas, final List<ACL> acl, boolean ownAllocator, boolean createIfNotExists, final CompletableFuture<List<Versioned<byte[]>>> promise) {
        final ArrayList pathsToCreate = Lists.newArrayListWithExpectedSize((int)metadatas.size());
        final ArrayList zkOps = Lists.newArrayListWithExpectedSize((int)metadatas.size());
        final CreateMode createMode = CreateMode.PERSISTENT;
        String logRootParentPath = Utils.getParent(logRootPath);
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(0))) {
            pathsToCreate.add(null);
        } else {
            pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
            zkOps.add(Op.create((String)logRootParentPath, (byte[])DistributedLogConstants.EMPTY_BYTES, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(1))) {
            pathsToCreate.add(null);
        } else {
            pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
            zkOps.add(Op.create((String)logRootPath, (byte[])DistributedLogConstants.EMPTY_BYTES, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(2))) {
            pathsToCreate.add(null);
        } else {
            byte[] zeroTxnIdData = DLUtils.serializeTransactionId(0L);
            pathsToCreate.add(zeroTxnIdData);
            zkOps.add(Op.create((String)(logRootPath + "/maxtxid"), (byte[])zeroTxnIdData, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(3))) {
            pathsToCreate.add(null);
        } else {
            byte[] versionData = ZKLogStreamMetadataStore.intToBytes(-1);
            pathsToCreate.add(versionData);
            zkOps.add(Op.create((String)(logRootPath + "/version"), (byte[])versionData, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(4))) {
            pathsToCreate.add(null);
        } else {
            pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
            zkOps.add(Op.create((String)(logRootPath + "/lock"), (byte[])DistributedLogConstants.EMPTY_BYTES, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(5))) {
            pathsToCreate.add(null);
        } else {
            pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
            zkOps.add(Op.create((String)(logRootPath + "/readLock"), (byte[])DistributedLogConstants.EMPTY_BYTES, acl, (CreateMode)createMode));
        }
        if (ZKLogStreamMetadataStore.pathExists(metadatas.get(6))) {
            pathsToCreate.add(null);
        } else {
            byte[] logSegmentsData = DLUtils.serializeLogSegmentSequenceNumber(0L);
            pathsToCreate.add(logSegmentsData);
            zkOps.add(Op.create((String)(logRootPath + "/ledgers"), (byte[])logSegmentsData, acl, (CreateMode)createMode));
        }
        if (ownAllocator) {
            if (ZKLogStreamMetadataStore.pathExists(metadatas.get(7))) {
                pathsToCreate.add(null);
            } else {
                pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
                zkOps.add(Op.create((String)(logRootPath + "/allocation"), (byte[])DistributedLogConstants.EMPTY_BYTES, acl, (CreateMode)createMode));
            }
        }
        if (zkOps.isEmpty()) {
            promise.complete(metadatas);
            return;
        }
        if (!createIfNotExists) {
            promise.completeExceptionally(new LogNotFoundException("Log " + logRootPath + " not found"));
            return;
        }
        ZKLogStreamMetadataStore.getMissingPaths(zk, basePath, Utils.getParent(logRootParentPath)).whenComplete((BiConsumer)new FutureEventListener<List<String>>(){

            public void onSuccess(List<String> paths) {
                for (String path : paths) {
                    pathsToCreate.add(DistributedLogConstants.EMPTY_BYTES);
                    zkOps.add(0, Op.create((String)path, (byte[])DistributedLogConstants.EMPTY_BYTES, (List)acl, (CreateMode)createMode));
                }
                ZKLogStreamMetadataStore.executeCreateMissingPathTxn(zk, zkOps, pathsToCreate, metadatas, logRootPath, promise);
            }

            public void onFailure(Throwable cause) {
                promise.completeExceptionally(cause);
            }
        });
    }

    private static void executeCreateMissingPathTxn(ZooKeeper zk, List<Op> zkOps, final List<byte[]> pathsToCreate, final List<Versioned<byte[]>> metadatas, final String logRootPath, final CompletableFuture<List<Versioned<byte[]>>> promise) {
        zk.multi(zkOps, new AsyncCallback.MultiCallback(){

            public void processResult(int rc, String path, Object ctx, List<OpResult> resultList) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    ArrayList finalMetadatas = Lists.newArrayListWithExpectedSize((int)metadatas.size());
                    for (int i = 0; i < pathsToCreate.size(); ++i) {
                        byte[] dataCreated = (byte[])pathsToCreate.get(i);
                        if (null == dataCreated) {
                            finalMetadatas.add(metadatas.get(i));
                            continue;
                        }
                        finalMetadatas.add(new Versioned((Object)dataCreated, (Version)new LongVersion(0L)));
                    }
                    promise.complete(finalMetadatas);
                } else if (KeeperException.Code.NODEEXISTS.intValue() == rc) {
                    promise.completeExceptionally((Throwable)new LogExistsException("Someone just created log " + logRootPath));
                } else {
                    if (LOG.isDebugEnabled()) {
                        StringBuilder builder = new StringBuilder();
                        for (OpResult result : resultList) {
                            if (result instanceof OpResult.ErrorResult) {
                                OpResult.ErrorResult errorResult = (OpResult.ErrorResult)result;
                                builder.append(errorResult.getErr()).append(",");
                                continue;
                            }
                            builder.append(0).append(",");
                        }
                        String resultCodeList = builder.substring(0, builder.length() - 1);
                        LOG.debug("Failed to create log, full rc list = {}", (Object)resultCodeList);
                    }
                    promise.completeExceptionally((Throwable)((Object)new ZKException("Failed to create log " + logRootPath, KeeperException.Code.get((int)rc))));
                }
            }
        }, null);
    }

    static LogMetadataForWriter processLogMetadatas(URI uri, String logName, String logIdentifier, List<Versioned<byte[]>> metadatas, boolean ownAllocator) throws UnexpectedException {
        try {
            Versioned allocationData;
            Versioned<byte[]> maxTxnIdData = metadatas.get(2);
            ZKLogStreamMetadataStore.ensureMetadataExist(maxTxnIdData);
            Versioned<byte[]> versionData = metadatas.get(3);
            ZKLogStreamMetadataStore.ensureMetadataExist(maxTxnIdData);
            Preconditions.checkArgument((-1 == ZKLogStreamMetadataStore.bytesToInt((byte[])versionData.getValue()) ? 1 : 0) != 0);
            ZKLogStreamMetadataStore.ensureMetadataExist(metadatas.get(4));
            ZKLogStreamMetadataStore.ensureMetadataExist(metadatas.get(5));
            Versioned<byte[]> maxLSSNData = metadatas.get(6);
            ZKLogStreamMetadataStore.ensureMetadataExist(maxLSSNData);
            try {
                DLUtils.deserializeLogSegmentSequenceNumber((byte[])maxLSSNData.getValue());
            }
            catch (NumberFormatException nfe) {
                throw new UnexpectedException("Invalid max sequence number found in log " + logName, (Throwable)nfe);
            }
            if (ownAllocator) {
                allocationData = metadatas.get(7);
                ZKLogStreamMetadataStore.ensureMetadataExist((Versioned<byte[]>)allocationData);
            } else {
                allocationData = new Versioned(null, null);
            }
            return new LogMetadataForWriter(uri, logName, logIdentifier, maxLSSNData, maxTxnIdData, (Versioned<byte[]>)allocationData);
        }
        catch (IllegalArgumentException iae) {
            throw new UnexpectedException("Invalid log " + logName, (Throwable)iae);
        }
        catch (NullPointerException npe) {
            throw new UnexpectedException("Invalid log " + logName, (Throwable)npe);
        }
    }

    static CompletableFuture<LogMetadataForWriter> getLog(URI uri, String logName, String logIdentifier, ZooKeeperClient zooKeeperClient, boolean ownAllocator, boolean createIfNotExists) {
        String logRootPath = LogMetadata.getLogRootPath(uri, logName, logIdentifier);
        try {
            PathUtils.validatePath((String)logRootPath);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Illegal path value {} for stream {}", new Object[]{logRootPath, logName, e});
            return FutureUtils.exception((Throwable)new InvalidStreamNameException(logName, "Log name is invalid"));
        }
        try {
            ZooKeeper zk = zooKeeperClient.get();
            return ((CompletableFuture)ZKLogStreamMetadataStore.checkLogMetadataPaths(zk, logRootPath, ownAllocator).thenCompose(metadatas -> {
                CompletableFuture<List<Versioned<byte[]>>> promise = new CompletableFuture<List<Versioned<byte[]>>>();
                ZKLogStreamMetadataStore.createMissingMetadata(zk, uri.getPath(), logRootPath, metadatas, zooKeeperClient.getDefaultACL(), ownAllocator, createIfNotExists, promise);
                return promise;
            })).thenCompose(metadatas -> {
                try {
                    return FutureUtils.value((Object)ZKLogStreamMetadataStore.processLogMetadatas(uri, logName, logIdentifier, metadatas, ownAllocator));
                }
                catch (UnexpectedException e) {
                    return FutureUtils.exception((Throwable)e);
                }
            });
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)((Object)new ZKException("Encountered zookeeper connection issue on creating log " + logName, KeeperException.Code.CONNECTIONLOSS)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)new DLInterruptedException("Interrupted on creating log " + logName, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<LogMetadataForWriter> getLog(URI uri, String logName, boolean ownAllocator, boolean createIfNotExists) {
        return ZKLogStreamMetadataStore.getLog(uri, logName, this.conf.getUnpartitionedStreamName(), this.zooKeeperClient, ownAllocator, createIfNotExists);
    }

    @Override
    public CompletableFuture<Void> deleteLog(URI uri, final String logName) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        try {
            String streamPath = LogMetadata.getLogStreamPath(uri, logName);
            ZKUtil.deleteRecursive((ZooKeeper)this.zooKeeperClient.get(), (String)streamPath, (AsyncCallback.VoidCallback)new AsyncCallback.VoidCallback(){

                public void processResult(int rc, String path, Object ctx) {
                    if (KeeperException.Code.OK.intValue() != rc) {
                        FutureUtils.completeExceptionally((CompletableFuture)promise, (Throwable)((Object)new ZKException("Encountered zookeeper issue on deleting log stream " + logName, KeeperException.Code.get((int)rc))));
                        return;
                    }
                    FutureUtils.complete((CompletableFuture)promise, null);
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            FutureUtils.completeExceptionally(promise, (Throwable)((Object)new ZKException("Encountered zookeeper issue on deleting log stream " + logName, KeeperException.Code.CONNECTIONLOSS)));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FutureUtils.completeExceptionally(promise, (Throwable)new DLInterruptedException("Interrupted while deleting log stream " + logName));
        }
        catch (KeeperException e) {
            FutureUtils.completeExceptionally(promise, (Throwable)((Object)new ZKException("Encountered zookeeper issue on deleting log stream " + logName, e)));
        }
        return promise;
    }

    @Override
    public CompletableFuture<Void> renameLog(URI uri, String oldStreamName, String newStreamName) {
        return this.getLog(uri, oldStreamName, true, false).thenCompose(metadata -> this.renameLogMetadata(uri, (LogMetadataForWriter)metadata, newStreamName));
    }

    private CompletableFuture<Void> renameLogMetadata(URI uri, LogMetadataForWriter oldMetadata, String newStreamName) {
        LinkedList createOps = Lists.newLinkedList();
        LinkedList deleteOps = Lists.newLinkedList();
        List<ACL> acls = this.zooKeeperClient.getDefaultACL();
        String oldRootPath = oldMetadata.getLogRootPath();
        String newRootPath = LogMetadata.getLogRootPath(uri, newStreamName, this.conf.getUnpartitionedStreamName());
        deleteOps.addFirst(Op.delete((String)LogMetadata.getLogStreamPath(uri, oldMetadata.getLogName()), (int)-1));
        createOps.addLast(Op.create((String)newRootPath, (byte[])DistributedLogConstants.EMPTY_BYTES, acls, (CreateMode)CreateMode.PERSISTENT));
        deleteOps.addFirst(Op.delete((String)oldRootPath, (int)-1));
        Versioned<byte[]> maxTxIdData = oldMetadata.getMaxTxIdData();
        ZKLogStreamMetadataStore.deleteOldPathAndCreateNewPath(oldRootPath, "/maxtxid", maxTxIdData, newRootPath, DLUtils.serializeTransactionId(0L), acls, createOps, deleteOps);
        createOps.addLast(Op.create((String)(newRootPath + "/version"), (byte[])ZKLogStreamMetadataStore.intToBytes(-1), acls, (CreateMode)CreateMode.PERSISTENT));
        deleteOps.addFirst(Op.delete((String)(oldRootPath + "/version"), (int)-1));
        createOps.addLast(Op.create((String)(newRootPath + "/lock"), (byte[])DistributedLogConstants.EMPTY_BYTES, acls, (CreateMode)CreateMode.PERSISTENT));
        deleteOps.addFirst(Op.delete((String)(oldRootPath + "/lock"), (int)-1));
        createOps.addLast(Op.create((String)(newRootPath + "/readLock"), (byte[])DistributedLogConstants.EMPTY_BYTES, acls, (CreateMode)CreateMode.PERSISTENT));
        deleteOps.addFirst(Op.delete((String)(oldRootPath + "/readLock"), (int)-1));
        Versioned<byte[]> allocationData = oldMetadata.getAllocationData();
        ZKLogStreamMetadataStore.deleteOldPathAndCreateNewPath(oldRootPath, "/allocation", allocationData, newRootPath, DistributedLogConstants.EMPTY_BYTES, acls, createOps, deleteOps);
        Versioned<byte[]> maxLSSNData = oldMetadata.getMaxLSSNData();
        ZKLogStreamMetadataStore.deleteOldPathAndCreateNewPath(oldRootPath, "/ledgers", maxLSSNData, newRootPath, DLUtils.serializeLogSegmentSequenceNumber(0L), acls, createOps, deleteOps);
        CompletableFuture<List<LogSegmentMetadata>> segmentsFuture = ZKLogStreamMetadataStore.pathExists(maxLSSNData) ? ZKLogStreamMetadataStore.getLogSegments(this.zooKeeperClient, oldRootPath + "/ledgers") : FutureUtils.value(Collections.emptyList());
        return ((CompletableFuture)((CompletableFuture)segmentsFuture.thenApply(segments -> {
            for (LogSegmentMetadata segment : segments) {
                ZKLogStreamMetadataStore.deleteOldSegmentAndCreateNewSegment(segment, newRootPath + "/ledgers", acls, createOps, deleteOps);
            }
            return null;
        })).thenCompose(ignored -> ZKLogStreamMetadataStore.getMissingPaths(this.zooKeeperClient, uri, newStreamName))).thenCompose(paths -> {
            for (String path : paths) {
                createOps.addFirst(Op.create((String)path, (byte[])DistributedLogConstants.EMPTY_BYTES, (List)acls, (CreateMode)CreateMode.PERSISTENT));
            }
            return this.executeRenameTxn(oldRootPath, newRootPath, createOps, deleteOps);
        });
    }

    @VisibleForTesting
    static CompletableFuture<List<String>> getMissingPaths(ZooKeeperClient zkc, URI uri, String logName) {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (InterruptedException | ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)e);
        }
        String basePath = uri.getPath();
        String logStreamPath = LogMetadata.getLogStreamPath(uri, logName);
        return ZKLogStreamMetadataStore.getMissingPaths(zk, basePath, logStreamPath);
    }

    @VisibleForTesting
    static CompletableFuture<List<String>> getMissingPaths(ZooKeeper zk, String basePath, String logStreamPath) {
        LinkedList missingPaths = Lists.newLinkedList();
        CompletableFuture future = FutureUtils.createFuture();
        ZKLogStreamMetadataStore.existPath(zk, logStreamPath, basePath, missingPaths, future);
        return future;
    }

    private static void existPath(ZooKeeper zk, String path, String basePath, LinkedList<String> missingPaths, CompletableFuture<List<String>> future) {
        if (basePath.equals(path)) {
            future.complete(missingPaths);
            return;
        }
        zk.exists(path, false, (rc, path1, ctx, stat) -> {
            if (KeeperException.Code.OK.intValue() != rc && KeeperException.Code.NONODE.intValue() != rc) {
                future.completeExceptionally((Throwable)((Object)new ZKException("Failed to check existence of path " + path1, KeeperException.Code.get((int)rc))));
                return;
            }
            if (KeeperException.Code.OK.intValue() == rc) {
                future.complete(missingPaths);
                return;
            }
            missingPaths.addLast(path);
            String parentPath = Utils.getParent(path);
            ZKLogStreamMetadataStore.existPath(zk, parentPath, basePath, missingPaths, future);
        }, null);
    }

    private CompletableFuture<Void> executeRenameTxn(String oldLogPath, String newLogPath, LinkedList<Op> createOps, LinkedList<Op> deleteOps) {
        CompletableFuture future = FutureUtils.createFuture();
        ArrayList zkOps = Lists.newArrayListWithExpectedSize((int)(createOps.size() + deleteOps.size()));
        zkOps.addAll(createOps);
        zkOps.addAll(deleteOps);
        if (LOG.isDebugEnabled()) {
            for (Op op : zkOps) {
                if (op instanceof Op.Create) {
                    Op.Create create = (Op.Create)op;
                    LOG.debug("op : create {}", (Object)create.getPath());
                    continue;
                }
                if (op instanceof Op.Delete) {
                    Op.Delete delete = (Op.Delete)op;
                    LOG.debug("op : delete {}, record = {}", (Object)delete.getPath(), (Object)op.toRequestRecord());
                    continue;
                }
                LOG.debug("op : {}", (Object)op);
            }
        }
        try {
            this.zooKeeperClient.get().multi((Iterable)zkOps, (rc, path, ctx, opResults) -> {
                if (KeeperException.Code.OK.intValue() == rc) {
                    future.complete(null);
                } else if (KeeperException.Code.NODEEXISTS.intValue() == rc) {
                    future.completeExceptionally((Throwable)new LogExistsException("Someone just created new log " + newLogPath));
                } else if (KeeperException.Code.NOTEMPTY.intValue() == rc) {
                    future.completeExceptionally((Throwable)new LockingException(oldLogPath + "/lock", "Someone is holding a lock on log " + oldLogPath));
                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                    future.completeExceptionally(new LogNotFoundException("Log " + newLogPath + " is not found"));
                } else {
                    future.completeExceptionally((Throwable)((Object)new ZKException("Failed to rename log " + oldLogPath + " to " + newLogPath + " at path " + path, KeeperException.Code.get((int)rc))));
                }
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            future.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.completeExceptionally(e);
        }
        return future;
    }

    private static void deleteOldSegmentAndCreateNewSegment(LogSegmentMetadata oldMetadata, String newSegmentsPath, List<ACL> acls, LinkedList<Op> createOps, LinkedList<Op> deleteOps) {
        createOps.addLast(Op.create((String)(newSegmentsPath + "/" + oldMetadata.getZNodeName()), (byte[])oldMetadata.getFinalisedData().getBytes(StandardCharsets.UTF_8), acls, (CreateMode)CreateMode.PERSISTENT));
        deleteOps.addFirst(Op.delete((String)oldMetadata.getZkPath(), (int)-1));
    }

    private static void deleteOldPathAndCreateNewPath(String oldRootPath, String nodePath, Versioned<byte[]> pathData, String newRootPath, byte[] initData, List<ACL> acls, LinkedList<Op> createOps, LinkedList<Op> deleteOps) {
        if (ZKLogStreamMetadataStore.pathExists(pathData)) {
            createOps.addLast(Op.create((String)(newRootPath + nodePath), (byte[])((byte[])pathData.getValue()), acls, (CreateMode)CreateMode.PERSISTENT));
            deleteOps.addFirst(Op.delete((String)(oldRootPath + nodePath), (int)((int)((LongVersion)pathData.getVersion()).getLongVersion())));
        } else {
            createOps.addLast(Op.create((String)(newRootPath + nodePath), (byte[])initData, acls, (CreateMode)CreateMode.PERSISTENT));
        }
    }

    @VisibleForTesting
    static CompletableFuture<List<LogSegmentMetadata>> getLogSegments(ZooKeeperClient zk, String logSegmentsPath) {
        CompletableFuture future = FutureUtils.createFuture();
        try {
            zk.get().getChildren(logSegmentsPath, false, (rc, path, ctx, children, stat) -> {
                if (KeeperException.Code.OK.intValue() != rc) {
                    if (KeeperException.Code.NONODE.intValue() == rc) {
                        future.completeExceptionally(new LogNotFoundException("Log " + path + " not found"));
                    } else {
                        future.completeExceptionally((Throwable)((Object)new ZKException("Failed to get log segments from " + path, KeeperException.Code.get((int)rc))));
                    }
                    return;
                }
                ArrayList futures = Lists.newArrayListWithExpectedSize((int)children.size());
                for (String child : children) {
                    futures.add(LogSegmentMetadata.read(zk, logSegmentsPath + "/" + child));
                }
                FutureUtils.proxyTo((CompletableFuture)FutureUtils.collect((List)futures), (CompletableFuture)future);
            }, null);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            future.completeExceptionally(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.completeExceptionally(e);
        }
        return future;
    }

    static class MetadataIndex {
        static final int LOG_ROOT_PARENT = 0;
        static final int LOG_ROOT = 1;
        static final int MAX_TXID = 2;
        static final int VERSION = 3;
        static final int LOCK = 4;
        static final int READ_LOCK = 5;
        static final int LOGSEGMENTS = 6;
        static final int ALLOCATION = 7;

        MetadataIndex() {
        }
    }
}

