/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.function.Supplier;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuorumCnxManagerSocketConnectionTimeoutTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumCnxManagerSocketConnectionTimeoutTest.class);
    private QuorumUtil qu;

    @BeforeEach
    public void setUp() throws Exception {
        this.qu = new QuorumUtil(1, 2);
        this.qu.startAll();
    }

    @Test
    public void testSocketConnectionTimeoutDuringConnectingToElectionAddress() throws Exception {
        int leaderId = this.qu.getLeaderServer();
        InetSocketAddress leaderElectionAddress = this.qu.getLeaderQuorumPeer().getElectionAddress().getOne();
        QuorumCnxManager.setSocketFactory(() -> new SocketStub(leaderElectionAddress));
        this.qu.shutdown(leaderId);
        Assertions.assertTrue((boolean)ClientBase.waitForServerDown("127.0.0.1:" + this.qu.getPeer((int)leaderId).clientPort, ClientBase.CONNECTION_TIMEOUT), (String)"Timeout during waiting for current leader to go down");
        String errorMessage = "No new leader was elected";
        this.waitFor(errorMessage, () -> this.qu.leaderExists() && this.qu.getLeaderServer() != leaderId, 15);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.qu.shutdownAll();
        QuorumCnxManager.setSocketFactory((Supplier)QuorumCnxManager.DEFAULT_SOCKET_FACTORY);
    }

    final class SocketStub
    extends Socket {
        private final InetSocketAddress addressToTimeout;

        SocketStub(InetSocketAddress addressToTimeout) {
            this.addressToTimeout = addressToTimeout;
        }

        @Override
        public void connect(SocketAddress endpoint, int timeout) throws IOException {
            if (this.addressToTimeout.equals(endpoint)) {
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    LOG.warn("interrupted SocketStub.connect", (Throwable)e);
                }
                throw new SocketTimeoutException("timeout reached in SocketStub.connect()");
            }
            super.connect(endpoint, timeout);
        }
    }
}

