/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mockit.Invocation;
import mockit.Mock;
import mockit.MockUp;
import org.apache.jute.Record;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.metric.SimpleCounter;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.zookeeper.server.quorum.QuorumPeerMainTest;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.TxnDigest;
import org.apache.zookeeper.txn.TxnHeader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxnLogDigestTest
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger(TxnLogDigestTest.class);
    private ZooKeeper zk;
    private ZooKeeperServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.serverFactory.getZooKeeperServer();
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.zk != null) {
            this.zk.close();
        }
        MockedFileTxnLog.reset();
    }

    @Override
    public void setupCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled((boolean)true);
    }

    @Override
    public void cleanUpCustomizedEnv() {
        ZooKeeperServer.setDigestEnabled((boolean)false);
    }

    @BeforeAll
    public static void applyMockUps() {
        new MockedFileTxnLog();
    }

    @Test
    public void digestFromTxnLogsMatchesTree() throws Exception {
        SimpleCounter digestMistachesCount = (SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT;
        digestMistachesCount.reset();
        TxnLogDigestTest.performOperations((ZooKeeper)this.createClient(), "/digestFromTxnLogsMatchesTree");
        Assertions.assertEquals((long)0L, (long)digestMistachesCount.get());
        TxnDigest lastDigest = this.getLastTxnLogDigest();
        Assertions.assertNotNull((Object)lastDigest);
        Assertions.assertEquals((long)this.server.getZKDatabase().getDataTree().getTreeDigest(), (long)lastDigest.getTreeDigest());
    }

    @Test
    public void checkTxnCompatibleWithAndWithoutDigest() throws Exception {
        this.restartServerWithDigestFlag(false);
        Map<String, String> expectedNodes = TxnLogDigestTest.performOperations((ZooKeeper)this.createClient(), "/p1");
        SimpleCounter digestMistachesCount = (SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT;
        digestMistachesCount.reset();
        this.restartServerWithDigestFlag(true);
        this.checkNodes(expectedNodes);
        Map<String, String> expectedNodes1 = TxnLogDigestTest.performOperations((ZooKeeper)this.createClient(), "/p2");
        Assertions.assertEquals((long)0L, (long)digestMistachesCount.get());
        this.restartServerWithDigestFlag(false);
        this.checkNodes(expectedNodes);
        this.checkNodes(expectedNodes1);
    }

    @Test
    public void testTxnMissing() throws Exception {
        MockedFileTxnLog.skipAppendZxid = 3L;
        TxnLogDigestTest.performOperations((ZooKeeper)this.createClient(), "/testTxnMissing");
        SimpleCounter digestMistachesCount = (SimpleCounter)ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT;
        digestMistachesCount.reset();
        this.restartServerWithDigestFlag(true);
        MatcherAssert.assertThat((String)"mismtach should be reported", (Object)digestMistachesCount.get(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        digestMistachesCount.reset();
        this.restartServerWithDigestFlag(false);
        Assertions.assertEquals((long)0L, (long)digestMistachesCount.get());
    }

    private void restartServerWithDigestFlag(boolean digestEnabled) throws Exception {
        this.stopServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTING);
        ZooKeeperServer.setDigestEnabled((boolean)digestEnabled);
        this.startServer();
        QuorumPeerMainTest.waitForOne(this.zk, ZooKeeper.States.CONNECTED);
    }

    private TxnDigest getLastTxnLogDigest() throws IOException {
        TxnLog.TxnIterator itr = new FileTxnLog(new File(this.tmpDir, "version-2")).read(1L);
        TxnDigest lastDigest = null;
        while (itr.next()) {
            lastDigest = itr.getDigest();
        }
        return lastDigest;
    }

    public static void create(ZooKeeper client, String path, CreateMode mode) throws Exception {
        client.create(path, path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, mode);
    }

    public static Map<String, String> performOperations(ZooKeeper client, String prefix) throws Exception {
        HashMap<String, String> nodes = new HashMap<String, String>();
        String path = prefix;
        TxnLogDigestTest.create(client, path, CreateMode.PERSISTENT);
        nodes.put(path, path);
        path = prefix + "/child1";
        TxnLogDigestTest.create(client, path, CreateMode.PERSISTENT);
        nodes.put(path, path);
        path = prefix + "/child2";
        TxnLogDigestTest.create(client, path, CreateMode.PERSISTENT);
        client.delete(prefix + "/child2", -1);
        path = prefix + "/child1/leaf";
        TxnLogDigestTest.create(client, path, CreateMode.PERSISTENT);
        String updatedData = "updated data";
        client.setData(path, updatedData.getBytes(), -1);
        nodes.put(path, updatedData);
        ArrayList<Op> subTxns = new ArrayList<Op>();
        for (int i = 0; i < 3; ++i) {
            path = prefix + "/m" + i;
            subTxns.add(Op.create((String)path, (byte[])path.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT));
            nodes.put(path, path);
        }
        client.multi(subTxns);
        client.close();
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNodes(Map<String, String> expectedNodes) throws Exception {
        try (TestableZooKeeper client = this.createClient();){
            for (Map.Entry<String, String> entry : expectedNodes.entrySet()) {
                Assertions.assertEquals((Object)entry.getValue(), (Object)new String(client.getData(entry.getKey(), false, null)));
            }
        }
    }

    public static final class MockedFileTxnLog
    extends MockUp<FileTxnLog> {
        static long skipAppendZxid = -1L;

        @Mock
        public synchronized boolean append(Invocation invocation, TxnHeader hdr, Record txn, TxnDigest digest) throws IOException {
            if (hdr != null && hdr.getZxid() == skipAppendZxid) {
                LOG.info("skipping txn {}", (Object)skipAppendZxid);
                return true;
            }
            return (Boolean)invocation.proceed(new Object[]{hdr, txn, digest});
        }

        public static void reset() {
            skipAppendZxid = -1L;
        }
    }
}

