/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplicateLocalSessionUpgradeTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(DuplicateLocalSessionUpgradeTest.class);
    private final QuorumBase qb = new QuorumBase();
    private static final int CONNECTION_TIMEOUT = ClientBase.CONNECTION_TIMEOUT;

    @BeforeEach
    public void setUp() throws Exception {
        LOG.info("STARTING quorum {}", (Object)this.getClass().getName());
        this.qb.localSessionsEnabled = true;
        this.qb.localSessionsUpgradingEnabled = true;
        this.qb.setUp();
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
    }

    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum {}", (Object)this.getClass().getName());
        this.qb.tearDown();
    }

    @Test
    public void testLocalSessionUpgradeOnFollower() throws Exception {
        this.testLocalSessionUpgrade(false);
    }

    @Test
    public void testLocalSessionUpgradeOnLeader() throws Exception {
        this.testLocalSessionUpgrade(true);
    }

    private void testLocalSessionUpgrade(boolean testLeader) throws Exception {
        int leaderIdx = this.qb.getLeaderIndex();
        Assertions.assertFalse((leaderIdx == -1 ? 1 : 0) != 0, (String)"No leader in quorum?");
        int followerIdx = (leaderIdx + 1) % 5;
        int testPeerIdx = testLeader ? leaderIdx : followerIdx;
        String[] hostPorts = this.qb.hostPort.split(",");
        ClientBase.CountdownWatcher watcher = new ClientBase.CountdownWatcher();
        TestableZooKeeper zk = this.qb.createClient(watcher, hostPorts[testPeerIdx], CONNECTION_TIMEOUT);
        watcher.waitForConnected(CONNECTION_TIMEOUT);
        String firstPath = "/first";
        String secondPath = "/ephemeral";
        zk.create("/first", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/ephemeral", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Stat firstStat = zk.exists("/first", null);
        Assertions.assertNotNull((Object)firstStat);
        Stat secondStat = zk.exists("/ephemeral", null);
        Assertions.assertNotNull((Object)secondStat);
        long zxidDiff = secondStat.getCzxid() - firstStat.getCzxid();
        Assertions.assertEquals((long)2L, (long)zxidDiff);
    }
}

