/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Map;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.StateSummary;
import org.apache.zookeeper.server.quorum.SyncedLearnerTracker;
import org.apache.zookeeper.server.quorum.ZabUtils;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LeaderWithObserverTest {
    QuorumPeer peer;
    Leader leader;
    File tmpDir;
    long participantId;
    long observerId;

    @BeforeEach
    public void setUp() throws Exception {
        this.tmpDir = ClientBase.createTmpDir();
        this.peer = ZabUtils.createQuorumPeer(this.tmpDir);
        this.participantId = 1L;
        Map peers = this.peer.getQuorumVerifier().getAllMembers();
        this.observerId = peers.size();
        this.peer.leader = this.leader = ZabUtils.createLeader(this.tmpDir, this.peer);
        peers.put(this.observerId, new QuorumPeer.QuorumServer(this.observerId, new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), new InetSocketAddress("127.0.0.1", PortAssignment.unique()), QuorumPeer.LearnerType.OBSERVER));
        this.peer.tickTime = 1;
    }

    @AfterEach
    public void tearDown() {
        this.leader.shutdown("end of test");
        this.tmpDir.delete();
    }

    @Test
    public void testGetEpochToPropose() throws Exception {
        long lastAcceptedEpoch = 5L;
        this.peer.setAcceptedEpoch(5L);
        Assertions.assertEquals((int)0, (int)this.leader.connectingFollowers.size(), (String)"Unexpected vote in connectingFollowers");
        Assertions.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.peer.getMyId(), lastAcceptedEpoch);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)this.leader.connectingFollowers.size(), (String)"Unexpected vote in connectingFollowers");
        Assertions.assertEquals((long)lastAcceptedEpoch, (long)this.peer.getAcceptedEpoch(), (String)"Leader shouldn't set new epoch until quorum of participants is in connectingFollowers");
        Assertions.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.observerId, lastAcceptedEpoch);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)this.leader.connectingFollowers.size(), (String)"Unexpected vote in connectingFollowers");
        Assertions.assertEquals((long)lastAcceptedEpoch, (long)this.peer.getAcceptedEpoch(), (String)"Leader shouldn't set new epoch after observer asks for epoch");
        Assertions.assertTrue((boolean)this.leader.waitingForNewEpoch);
        try {
            this.leader.getEpochToPropose(this.participantId, lastAcceptedEpoch);
        }
        catch (Exception e) {
            Assertions.fail((String)"Timed out in getEpochToPropose");
        }
        Assertions.assertEquals((int)2, (int)this.leader.connectingFollowers.size(), (String)"Unexpected vote in connectingFollowers");
        Assertions.assertEquals((long)(lastAcceptedEpoch + 1L), (long)this.peer.getAcceptedEpoch(), (String)"Leader should record next epoch");
        Assertions.assertFalse((boolean)this.leader.waitingForNewEpoch);
    }

    @Test
    public void testWaitForEpochAck() throws Exception {
        this.leader.leaderStateSummary = new StateSummary(this.leader.self.getCurrentEpoch(), this.leader.zk.getLastProcessedZxid());
        Assertions.assertEquals((int)0, (int)this.leader.electingFollowers.size(), (String)"Unexpected vote in electingFollowers");
        Assertions.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.peer.getMyId(), new StateSummary(0L, 0L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)this.leader.electingFollowers.size(), (String)"Unexpected vote in electingFollowers");
        Assertions.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.observerId, new StateSummary(0L, 0L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)this.leader.electingFollowers.size(), (String)"Unexpected vote in electingFollowers");
        Assertions.assertFalse((boolean)this.leader.electionFinished);
        try {
            this.leader.waitForEpochAck(this.participantId, new StateSummary(0L, 0L));
            Assertions.assertEquals((int)2, (int)this.leader.electingFollowers.size(), (String)"Unexpected vote in electingFollowers");
            Assertions.assertTrue((boolean)this.leader.electionFinished);
        }
        catch (Exception e) {
            Assertions.fail((String)"Timed out in waitForEpochAck");
        }
    }

    @Test
    public void testWaitForNewLeaderAck() throws Exception {
        long zxid = this.leader.zk.getZxid();
        this.leader.newLeaderProposal.packet = new QuorumPacket(0, zxid, null, null);
        this.leader.newLeaderProposal.addQuorumVerifier(this.peer.getQuorumVerifier());
        HashSet ackSet = ((SyncedLearnerTracker.QuorumVerifierAcksetPair)this.leader.newLeaderProposal.qvAcksetPairs.get(0)).getAckset();
        Assertions.assertEquals((int)0, (int)ackSet.size(), (String)"Unexpected vote in ackSet");
        Assertions.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.peer.getMyId(), zxid);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)ackSet.size(), (String)"Unexpected vote in ackSet");
        Assertions.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.observerId, zxid);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((int)1, (int)ackSet.size(), (String)"Unexpected vote in ackSet");
        Assertions.assertFalse((boolean)this.leader.quorumFormed);
        try {
            this.leader.waitForNewLeaderAck(this.participantId, zxid);
            Assertions.assertEquals((int)2, (int)ackSet.size(), (String)"Unexpected vote in ackSet");
            Assertions.assertTrue((boolean)this.leader.quorumFormed);
        }
        catch (Exception e) {
            Assertions.fail((String)"Timed out in waitForEpochAck");
        }
    }
}

