/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.jute.OutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderBean;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.LearnerHandler;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.flexible.QuorumVerifier;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.txn.TxnHeader;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class LeaderBeanTest {
    private Leader leader;
    private LeaderBean leaderBean;
    private FileTxnSnapLog fileTxnSnapLog;
    private LeaderZooKeeperServer zks;
    private QuorumPeer qp;
    private QuorumVerifier quorumVerifierMock;

    public static Map<Long, QuorumPeer.QuorumServer> getMockedPeerViews(long myId) {
        int clientPort = PortAssignment.unique();
        HashMap<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
        InetAddress clientIP = InetAddress.getLoopbackAddress();
        peersView.put(myId, new QuorumPeer.QuorumServer(myId, new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, PortAssignment.unique()), new InetSocketAddress(clientIP, clientPort), QuorumPeer.LearnerType.PARTICIPANT));
        return peersView;
    }

    @BeforeEach
    public void setUp() throws IOException, X509Exception {
        this.qp = new QuorumPeer();
        this.quorumVerifierMock = (QuorumVerifier)Mockito.mock(QuorumVerifier.class);
        Mockito.when((Object)this.quorumVerifierMock.getAllMembers()).thenReturn(LeaderBeanTest.getMockedPeerViews(this.qp.getMyId()));
        this.qp.setQuorumVerifier(this.quorumVerifierMock, false);
        File tmpDir = ClientBase.createEmptyTestDir();
        this.fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZKDatabase zkDb = new ZKDatabase(this.fileTxnSnapLog);
        this.zks = new LeaderZooKeeperServer(this.fileTxnSnapLog, this.qp, zkDb);
        this.leader = new Leader(this.qp, this.zks);
        this.leaderBean = new LeaderBean(this.leader, (ZooKeeperServer)this.zks);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.fileTxnSnapLog.close();
    }

    @Test
    public void testGetName() {
        Assertions.assertEquals((Object)"Leader", (Object)this.leaderBean.getName());
    }

    @Test
    public void testGetCurrentZxid() {
        this.zks.setZxid(1L);
        Assertions.assertEquals((Object)"0x1", (Object)this.leaderBean.getCurrentZxid());
    }

    @Test
    public void testGetElectionTimeTaken() {
        this.qp.setElectionTimeTaken(1L);
        Assertions.assertEquals((long)1L, (long)this.leaderBean.getElectionTimeTaken());
    }

    @Test
    public void testGetProposalSize() throws IOException, Leader.XidRolloverException {
        Request req = this.createMockRequest();
        this.leader.propose(req);
        byte[] data = SerializeUtils.serializeRequest((Request)req);
        Assertions.assertEquals((int)data.length, (int)this.leaderBean.getLastProposalSize());
        Assertions.assertEquals((int)data.length, (int)this.leaderBean.getMinProposalSize());
        Assertions.assertEquals((int)data.length, (int)this.leaderBean.getMaxProposalSize());
    }

    @Test
    public void testResetProposalStats() throws IOException, Leader.XidRolloverException {
        int initialProposalSize = this.leaderBean.getLastProposalSize();
        Request req = this.createMockRequest();
        this.leader.propose(req);
        Assertions.assertNotEquals((int)initialProposalSize, (int)this.leaderBean.getLastProposalSize());
        this.leaderBean.resetProposalStatistics();
        Assertions.assertEquals((int)initialProposalSize, (int)this.leaderBean.getLastProposalSize());
        Assertions.assertEquals((int)initialProposalSize, (int)this.leaderBean.getMinProposalSize());
        Assertions.assertEquals((int)initialProposalSize, (int)this.leaderBean.getMaxProposalSize());
    }

    private Request createMockRequest() throws IOException {
        TxnHeader header = (TxnHeader)Mockito.mock(TxnHeader.class);
        ((TxnHeader)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("header", "test");
                return null;
            }
        }).when((Object)header)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        Record txn = (Record)Mockito.mock(Record.class);
        ((Record)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                OutputArchive oa = (OutputArchive)args[0];
                oa.writeString("record", "test");
                return null;
            }
        }).when((Object)txn)).serialize((OutputArchive)ArgumentMatchers.any(OutputArchive.class), ArgumentMatchers.anyString());
        return new Request(1L, 2, 3, header, txn, 4L);
    }

    @Test
    public void testFollowerInfo() throws IOException {
        HashMap<Long, Object> votingMembers = new HashMap<Long, Object>();
        votingMembers.put(1L, null);
        votingMembers.put(2L, null);
        votingMembers.put(3L, null);
        Mockito.when((Object)this.quorumVerifierMock.getVotingMembers()).thenReturn(votingMembers);
        LearnerHandler follower = (LearnerHandler)Mockito.mock(LearnerHandler.class);
        Mockito.when((Object)follower.getLearnerType()).thenReturn((Object)QuorumPeer.LearnerType.PARTICIPANT);
        Mockito.when((Object)follower.toString()).thenReturn((Object)"1");
        Mockito.when((Object)follower.getSid()).thenReturn((Object)1L);
        this.leader.addLearnerHandler(follower);
        this.leader.addForwardingFollower(follower);
        Assertions.assertEquals((Object)"1\n", (Object)this.leaderBean.followerInfo());
        Assertions.assertEquals((Object)"", (Object)this.leaderBean.nonVotingFollowerInfo());
        LearnerHandler observer = (LearnerHandler)Mockito.mock(LearnerHandler.class);
        Mockito.when((Object)observer.getLearnerType()).thenReturn((Object)QuorumPeer.LearnerType.OBSERVER);
        Mockito.when((Object)observer.toString()).thenReturn((Object)"2");
        this.leader.addLearnerHandler(observer);
        Assertions.assertEquals((Object)"1\n", (Object)this.leaderBean.followerInfo());
        Assertions.assertEquals((Object)"", (Object)this.leaderBean.nonVotingFollowerInfo());
        LearnerHandler nonVotingFollower = (LearnerHandler)Mockito.mock(LearnerHandler.class);
        Mockito.when((Object)nonVotingFollower.getLearnerType()).thenReturn((Object)QuorumPeer.LearnerType.PARTICIPANT);
        Mockito.when((Object)nonVotingFollower.toString()).thenReturn((Object)"5");
        Mockito.when((Object)nonVotingFollower.getSid()).thenReturn((Object)5L);
        this.leader.addLearnerHandler(nonVotingFollower);
        this.leader.addForwardingFollower(nonVotingFollower);
        String followerInfo = this.leaderBean.followerInfo();
        Assertions.assertTrue((boolean)followerInfo.contains("1"));
        Assertions.assertTrue((boolean)followerInfo.contains("5"));
        Assertions.assertEquals((Object)"5\n", (Object)this.leaderBean.nonVotingFollowerInfo());
    }
}

