/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.persistence;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.number.OrderingComparison;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnSnapLogMetricsTest
extends ZKTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(FileTxnSnapLogMetricsTest.class);
    @TempDir
    File logDir;
    @TempDir
    File snapDir;

    private ServerCnxnFactory startServer() throws Exception {
        ZooKeeperServer zkServer = new ZooKeeperServer(this.snapDir, this.logDir, 3000);
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory((int)0, (int)-1);
        cnxnFactory.startup(zkServer);
        return cnxnFactory;
    }

    @AfterEach
    public void cleanup() throws Exception {
        SyncRequestProcessor.setSnapCount((int)ZooKeeperServer.getSnapCount());
    }

    @Test
    public void testFileTxnSnapLogMetrics() throws Exception {
        SyncRequestProcessor.setSnapCount((int)100);
        ServerCnxnFactory cnxnFactory = this.startServer();
        String connectString = "127.0.0.1:" + cnxnFactory.getLocalPort();
        Assertions.assertEquals((Object)1L, (Object)MetricsUtils.currentServerMetrics().get("cnt_snapshottime"));
        byte[] data = new byte[500];
        ZooKeeper zk = ClientBase.createZKClient(connectString);
        for (int i = 0; i < 150; ++i) {
            zk.create("/path" + i, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        ZKTestCase.WaitForCondition newSnapshot = () -> (Long)MetricsUtils.currentServerMetrics().get("cnt_snapshottime") >= 2L;
        this.waitFor("no snapshot in 10s", newSnapshot, 10);
        cnxnFactory.getZooKeeperServer().getTxnLogFactory().snapLog.close();
        zk.create("/1000", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        zk.create("/1001", data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        cnxnFactory.shutdown();
        ServerMetrics.getMetrics().resetAll();
        cnxnFactory = this.startServer();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        LOG.info("txn loaded during start up {}", values.get("max_startup_txns_loaded"));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_loaded"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_txns_loaded")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_txns_load_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_txns_load_time")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        Assertions.assertEquals((Object)1L, (Object)values.get("cnt_startup_snap_load_time"));
        MatcherAssert.assertThat((Object)((Long)values.get("max_startup_snap_load_time")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        cnxnFactory.shutdown();
    }
}

