/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.proto.ConnectRequest;
import org.apache.zookeeper.server.MockServerCnxn;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.Test;

public class ZooKeeperServerCreationTest {
    @Test
    public void testDefaultConstructor() throws Exception {
        File tmpDir = ClientBase.createEmptyTestDir();
        FileTxnSnapLog fileTxnSnapLog = new FileTxnSnapLog(new File(tmpDir, "data"), new File(tmpDir, "data_txnlog"));
        ZooKeeperServer zks = new ZooKeeperServer(){

            public void submitRequest(Request si) {
            }
        };
        zks.setTxnLogFactory(fileTxnSnapLog);
        zks.setZKDatabase(new ZKDatabase(fileTxnSnapLog));
        zks.createSessionTracker();
        ServerCnxnFactory cnxnFactory = ServerCnxnFactory.createFactory();
        MockServerCnxn cnxn = new MockServerCnxn();
        ConnectRequest connReq = new ConnectRequest();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)baos);
        connReq.serialize((OutputArchive)boa, "connect");
        zks.processConnectRequest((ServerCnxn)cnxn, ByteBuffer.wrap(baos.toByteArray()));
    }
}

