/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.zk;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.util.Transaction;
import org.apache.distributedlog.util.Utils;
import org.apache.distributedlog.zk.ZKOp;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;

public class ZKTransaction
implements Transaction<Object>,
AsyncCallback.MultiCallback {
    private final ZooKeeperClient zkc;
    private final List<ZKOp> ops;
    private final List<Op> zkOps;
    private final CompletableFuture<Void> result;
    private final AtomicBoolean done = new AtomicBoolean(false);

    public ZKTransaction(ZooKeeperClient zkc) {
        this.zkc = zkc;
        this.ops = Lists.newArrayList();
        this.zkOps = Lists.newArrayList();
        this.result = new CompletableFuture();
    }

    @Override
    public void addOp(Transaction.Op<Object> operation) {
        if (this.done.get()) {
            throw new IllegalStateException("Add an operation to a finished transaction");
        }
        assert (operation instanceof ZKOp);
        ZKOp zkOp = (ZKOp)operation;
        this.ops.add(zkOp);
        this.zkOps.add(zkOp.getOp());
    }

    @Override
    public CompletableFuture<Void> execute() {
        if (!this.done.compareAndSet(false, true)) {
            return this.result;
        }
        if (this.zkOps.isEmpty()) {
            this.processResult(KeeperException.Code.OK.intValue(), null, null, Collections.emptyList());
        } else {
            try {
                this.zkc.get().multi(this.zkOps, (AsyncCallback.MultiCallback)this, this.result);
            }
            catch (ZooKeeperClient.ZooKeeperConnectionException e) {
                this.result.completeExceptionally(Utils.zkException(e, ""));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.result.completeExceptionally(Utils.zkException(e, ""));
            }
        }
        return this.result;
    }

    @Override
    public void abort(Throwable cause) {
        if (!this.done.compareAndSet(false, true)) {
            return;
        }
        for (int i = 0; i < this.ops.size(); ++i) {
            this.ops.get(i).abortOpResult(cause, null);
        }
        FutureUtils.completeExceptionally(this.result, (Throwable)cause);
    }

    public void processResult(int rc, String path, Object ctx, List<OpResult> results) {
        if (KeeperException.Code.OK.intValue() == rc) {
            for (int i = 0; i < this.ops.size(); ++i) {
                this.ops.get(i).commitOpResult(results.get(i));
            }
            FutureUtils.complete(this.result, null);
        } else {
            KeeperException ke = KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc));
            for (int i = 0; i < this.ops.size(); ++i) {
                this.ops.get(i).abortOpResult((Throwable)ke, null != results ? results.get(i) : null);
            }
            FutureUtils.completeExceptionally(this.result, (Throwable)ke);
        }
    }
}

