/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.util;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.ZooKeeperClient;
import org.apache.distributedlog.common.functions.VoidFunctions;
import org.apache.distributedlog.exceptions.BKTransmitException;
import org.apache.distributedlog.exceptions.DLInterruptedException;
import org.apache.distributedlog.exceptions.UnexpectedException;
import org.apache.distributedlog.exceptions.ZKException;
import org.apache.distributedlog.io.AsyncAbortable;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static long nowInNanos() {
        return System.nanoTime();
    }

    public static long nowInMillis() {
        return System.currentTimeMillis();
    }

    public static long elapsedMSec(long startMsecTime) {
        return System.currentTimeMillis() - startMsecTime;
    }

    public static boolean randomPercent(double percent) {
        return Math.random() * 100.0 <= percent;
    }

    public static void zkCreateFullPathOptimistic(ZooKeeperClient zkc, String path, byte[] data, List<ACL> acl, CreateMode createMode) throws IOException, KeeperException {
        try {
            FutureUtils.result(Utils.zkAsyncCreateFullPathOptimistic(zkc, path, data, acl, createMode));
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException zkce) {
            throw zkce;
        }
        catch (KeeperException ke) {
            throw ke;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on create zookeeper path " + path, (Throwable)ie);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception exc) {
            throw new RuntimeException("Unexpected Exception", exc);
        }
    }

    public static void zkAsyncCreateFullPathOptimisticRecursive(final ZooKeeperClient zkc, final String pathToCreate, final Optional<String> parentPathShouldNotCreate, final byte[] data, final List<ACL> acl, final CreateMode createMode, final AsyncCallback.StringCallback callback, Object ctx) {
        try {
            zkc.get().create(pathToCreate, data, acl, createMode, new AsyncCallback.StringCallback(){

                public void processResult(int rc, String path, Object ctx, String name) {
                    if (rc != KeeperException.Code.NONODE.intValue()) {
                        callback.processResult(rc, path, ctx, name);
                        return;
                    }
                    int lastSlash = pathToCreate.lastIndexOf(47);
                    if (lastSlash <= 0) {
                        callback.processResult(rc, path, ctx, name);
                        return;
                    }
                    String parent = pathToCreate.substring(0, lastSlash);
                    if (parentPathShouldNotCreate.isPresent() && Objects.equal(parentPathShouldNotCreate.get(), (Object)parent)) {
                        callback.processResult(rc, path, ctx, name);
                        return;
                    }
                    Utils.zkAsyncCreateFullPathOptimisticRecursive(zkc, parent, parentPathShouldNotCreate, new byte[0], acl, CreateMode.PERSISTENT, new AsyncCallback.StringCallback(){

                        public void processResult(int rc, String path, Object ctx, String name) {
                            if (rc == KeeperException.Code.OK.intValue() || rc == KeeperException.Code.NODEEXISTS.intValue()) {
                                Utils.zkAsyncCreateFullPathOptimisticRecursive(zkc, pathToCreate, parentPathShouldNotCreate, data, acl, createMode, callback, ctx);
                            } else {
                                callback.processResult(rc, path, ctx, name);
                            }
                        }
                    }, ctx);
                }
            }, ctx);
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException zkce) {
            callback.processResult(-2147483646, zkce.getMessage(), ctx, pathToCreate);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            callback.processResult(-2147483647, ie.getMessage(), ctx, pathToCreate);
        }
    }

    public static CompletableFuture<Void> zkAsyncCreateFullPathOptimistic(ZooKeeperClient zkc, String pathToCreate, byte[] data, List<ACL> acl, CreateMode createMode) {
        Optional<String> parentPathShouldNotCreate = Optional.empty();
        return Utils.zkAsyncCreateFullPathOptimistic(zkc, pathToCreate, parentPathShouldNotCreate, data, acl, createMode);
    }

    public static CompletableFuture<Void> zkAsyncCreateFullPathOptimistic(ZooKeeperClient zkc, String pathToCreate, Optional<String> parentPathShouldNotCreate, byte[] data, List<ACL> acl, CreateMode createMode) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        Utils.zkAsyncCreateFullPathOptimisticRecursive(zkc, pathToCreate, parentPathShouldNotCreate, data, acl, createMode, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                Utils.handleKeeperExceptionCode(rc, path, result);
            }
        }, result);
        return result;
    }

    public static CompletableFuture<Void> zkAsyncCreateFullPathOptimisticAndSetData(final ZooKeeperClient zkc, final String pathToCreate, final byte[] data, final List<ACL> acl, final CreateMode createMode) {
        final CompletableFuture<Void> result = new CompletableFuture<Void>();
        try {
            zkc.get().setData(pathToCreate, data, -1, new AsyncCallback.StatCallback(){

                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    if (rc != KeeperException.Code.NONODE.intValue()) {
                        Utils.handleKeeperExceptionCode(rc, path, result);
                        return;
                    }
                    Optional<String> parentPathShouldNotCreate = Optional.empty();
                    Utils.zkAsyncCreateFullPathOptimisticRecursive(zkc, pathToCreate, parentPathShouldNotCreate, data, acl, createMode, new AsyncCallback.StringCallback(){

                        public void processResult(int rc, String path, Object ctx, String name) {
                            Utils.handleKeeperExceptionCode(rc, path, result);
                        }
                    }, result);
                }
            }, result);
        }
        catch (Exception exc) {
            result.completeExceptionally(exc);
        }
        return result;
    }

    private static void handleKeeperExceptionCode(int rc, String pathOrMessage, CompletableFuture<Void> result) {
        if (KeeperException.Code.OK.intValue() == rc) {
            result.complete(null);
        } else if (-2147483646 == rc) {
            result.completeExceptionally(new ZooKeeperClient.ZooKeeperConnectionException(pathOrMessage));
        } else if (-2147483647 == rc) {
            result.completeExceptionally((Throwable)new DLInterruptedException(pathOrMessage));
        } else {
            result.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc), (String)pathOrMessage));
        }
    }

    public static CompletableFuture<Versioned<byte[]>> zkGetData(ZooKeeperClient zkc, String path, boolean watch) {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        return Utils.zkGetData(zk, path, watch);
    }

    public static CompletableFuture<Versioned<byte[]>> zkGetData(ZooKeeper zk, String path, boolean watch) {
        final CompletableFuture<Versioned<byte[]>> promise = new CompletableFuture<Versioned<byte[]>>();
        zk.getData(path, watch, new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    if (null == stat) {
                        promise.complete(new Versioned(null, null));
                    } else {
                        promise.complete(new Versioned((Object)data, (Version)new LongVersion((long)stat.getVersion())));
                    }
                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                    promise.complete(new Versioned(null, null));
                } else {
                    promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }
        }, null);
        return promise;
    }

    public static CompletableFuture<LongVersion> zkSetData(ZooKeeperClient zkc, String path, byte[] data, LongVersion version) {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        return Utils.zkSetData(zk, path, data, version);
    }

    public static CompletableFuture<LongVersion> zkSetData(ZooKeeper zk, String path, byte[] data, LongVersion version) {
        final CompletableFuture<LongVersion> promise = new CompletableFuture<LongVersion>();
        zk.setData(path, data, (int)version.getLongVersion(), new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    promise.complete(new LongVersion((long)stat.getVersion()));
                    return;
                }
                promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }, null);
        return promise;
    }

    public static CompletableFuture<Void> zkDelete(ZooKeeperClient zkc, String path, LongVersion version) {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        return Utils.zkDelete(zk, path, version);
    }

    public static CompletableFuture<Void> zkDelete(ZooKeeper zk, String path, LongVersion version) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        zk.delete(path, (int)version.getLongVersion(), new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    promise.complete(null);
                    return;
                }
                promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
            }
        }, null);
        return promise;
    }

    public static CompletableFuture<Boolean> zkDeleteIfNotExist(ZooKeeperClient zkc, String path, LongVersion version) {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (ZooKeeperClient.ZooKeeperConnectionException e) {
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return FutureUtils.exception((Throwable)Utils.zkException(e, path));
        }
        final CompletableFuture<Boolean> promise = new CompletableFuture<Boolean>();
        zk.delete(path, (int)version.getLongVersion(), new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    promise.complete(true);
                } else if (KeeperException.Code.NONODE.intValue() == rc) {
                    promise.complete(false);
                } else {
                    promise.completeExceptionally(KeeperException.create((KeeperException.Code)KeeperException.Code.get((int)rc)));
                }
            }
        }, null);
        return promise;
    }

    public static CompletableFuture<Void> asyncClose(@Nullable AsyncCloseable closeable, boolean swallowIOException) {
        if (null == closeable) {
            return FutureUtils.Void();
        }
        if (swallowIOException) {
            return FutureUtils.ignore((CompletableFuture)closeable.asyncClose());
        }
        return closeable.asyncClose();
    }

    public static ZooKeeper sync(ZooKeeperClient zkc, String path) throws IOException {
        ZooKeeper zk;
        try {
            zk = zkc.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on checking if log " + path + " exists", (Throwable)e);
        }
        final CountDownLatch syncLatch = new CountDownLatch(1);
        final AtomicInteger syncResult = new AtomicInteger(0);
        zk.sync(path, new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                syncResult.set(rc);
                syncLatch.countDown();
            }
        }, null);
        try {
            syncLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DLInterruptedException("Interrupted on syncing zookeeper connection", (Throwable)e);
        }
        if (KeeperException.Code.OK.intValue() != syncResult.get()) {
            throw new ZKException("Error syncing zookeeper connection ", KeeperException.Code.get((int)syncResult.get()));
        }
        return zk;
    }

    public static void close(@Nullable Closeable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(@Nullable AsyncCloseable closeable) throws IOException {
        if (null == closeable) {
            return;
        }
        Utils.ioResult(closeable.asyncClose());
    }

    public static void closeQuietly(@Nullable AsyncCloseable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            Utils.ioResult(closeable.asyncClose());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static CompletableFuture<Void> closeSequence(ExecutorService executorService, AsyncCloseable ... closeables) {
        return Utils.closeSequence(executorService, false, closeables);
    }

    public static CompletableFuture<Void> closeSequence(ExecutorService executorService, boolean ignoreCloseError, AsyncCloseable ... closeables) {
        ArrayList closeableList = Lists.newArrayListWithExpectedSize((int)closeables.length);
        for (AsyncCloseable closeable : closeables) {
            if (null == closeable) {
                closeableList.add(AsyncCloseable.NULL);
                continue;
            }
            closeableList.add(closeable);
        }
        return FutureUtils.processList((List)closeableList, (Function)(ignoreCloseError ? AsyncCloseable.CLOSE_FUNC_IGNORE_ERRORS : AsyncCloseable.CLOSE_FUNC), (ExecutorService)executorService).thenApply(VoidFunctions.LIST_TO_VOID_FUNC);
    }

    public static String getParent(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() < 2) {
            return null;
        }
        int firstIndex = path.indexOf("/");
        if (firstIndex == -1) {
            return null;
        }
        int lastIndex = path.lastIndexOf("/");
        if (lastIndex == path.length() - 1) {
            lastIndex = path.substring(0, path.length() - 1).lastIndexOf("/");
        }
        if (lastIndex == -1) {
            return null;
        }
        if (lastIndex == 0) {
            return "/";
        }
        return path.substring(0, lastIndex);
    }

    public static Throwable zkException(Throwable throwable, String path) {
        if (throwable instanceof KeeperException) {
            return new ZKException("Encountered zookeeper exception on " + path, (KeeperException)throwable);
        }
        if (throwable instanceof ZooKeeperClient.ZooKeeperConnectionException) {
            return new ZKException("Encountered zookeeper connection loss on " + path, KeeperException.Code.CONNECTIONLOSS);
        }
        if (throwable instanceof InterruptedException) {
            return new DLInterruptedException("Interrupted on operating " + path, throwable);
        }
        return new UnexpectedException("Encountered unexpected exception on operatiing " + path, throwable);
    }

    public static BKTransmitException transmitException(int transmitResult) {
        return new BKTransmitException("Failed to write to bookkeeper; Error is (" + transmitResult + ") " + BKException.getMessage((int)transmitResult), transmitResult);
    }

    public static <T> T ioResult(CompletableFuture<T> result) throws IOException {
        return (T)FutureUtils.result(result, cause -> {
            if (cause instanceof IOException) {
                return (IOException)cause;
            }
            if (cause instanceof KeeperException) {
                return new ZKException("Encountered zookeeper exception on waiting result", (KeeperException)((Object)cause));
            }
            if (cause instanceof BKException) {
                return new BKTransmitException("Encountered bookkeeper exception on waiting result", ((BKException)cause).getCode());
            }
            if (cause instanceof InterruptedException) {
                return new DLInterruptedException("Interrupted on waiting result", cause);
            }
            return new IOException("Encountered exception on waiting result", (Throwable)cause);
        });
    }

    public static <T> T ioResult(CompletableFuture<T> result, long timeout, TimeUnit timeUnit) throws IOException, TimeoutException {
        return (T)FutureUtils.result(result, cause -> {
            if (cause instanceof IOException) {
                return (IOException)cause;
            }
            if (cause instanceof KeeperException) {
                return new ZKException("Encountered zookeeper exception on waiting result", (KeeperException)((Object)cause));
            }
            if (cause instanceof BKException) {
                return new BKTransmitException("Encountered bookkeeper exception on waiting result", ((BKException)cause).getCode());
            }
            if (cause instanceof InterruptedException) {
                return new DLInterruptedException("Interrupted on waiting result", cause);
            }
            return new IOException("Encountered exception on waiting result", (Throwable)cause);
        }, (long)timeout, (TimeUnit)timeUnit);
    }

    public static void abort(@Nullable AsyncAbortable abortable, boolean swallowIOException) throws IOException {
        if (null == abortable) {
            return;
        }
        try {
            Utils.ioResult(abortable.asyncAbort());
        }
        catch (Exception ioe) {
            if (swallowIOException) {
                log.warn("IOException thrown while aborting Abortable {} : ", (Object)abortable, (Object)ioe);
            }
            throw ioe;
        }
    }
}

