/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.rbac.engine;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import io.grpc.xds.internal.rbac.engine.AuthorizationDecision;
import io.grpc.xds.internal.rbac.engine.EvaluateArgs;
import io.grpc.xds.internal.rbac.engine.cel.Activation;
import io.grpc.xds.internal.rbac.engine.cel.DefaultDispatcher;
import io.grpc.xds.internal.rbac.engine.cel.DefaultInterpreter;
import io.grpc.xds.internal.rbac.engine.cel.DescriptorMessageProvider;
import io.grpc.xds.internal.rbac.engine.cel.IncompleteData;
import io.grpc.xds.internal.rbac.engine.cel.Interpretable;
import io.grpc.xds.internal.rbac.engine.cel.InterpreterException;
import io.grpc.xds.shaded.com.google.api.expr.v1alpha1.Expr;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v2.Policy;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.rbac.v2.RBAC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuthorizationEngine {
    private static final Logger log = Logger.getLogger(AuthorizationEngine.class.getName());
    private final RbacEngine allowEngine;
    private final RbacEngine denyEngine;

    public AuthorizationEngine(RBAC rbacPolicy) {
        LinkedHashMap<String, Expr> conditions = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Policy> policy : rbacPolicy.getPolicies().entrySet()) {
            conditions.put(policy.getKey(), policy.getValue().getCondition());
        }
        this.allowEngine = rbacPolicy.getAction() == RBAC.Action.ALLOW ? new RbacEngine(RBAC.Action.ALLOW, (ImmutableMap<String, Expr>)ImmutableMap.copyOf(conditions)) : null;
        this.denyEngine = rbacPolicy.getAction() == RBAC.Action.DENY ? new RbacEngine(RBAC.Action.DENY, (ImmutableMap<String, Expr>)ImmutableMap.copyOf(conditions)) : null;
    }

    public AuthorizationEngine(RBAC denyPolicy, RBAC allowPolicy) {
        Preconditions.checkArgument((denyPolicy.getAction() == RBAC.Action.DENY && allowPolicy.getAction() == RBAC.Action.ALLOW ? 1 : 0) != 0, (Object)"Invalid RBAC list, must provide a RBAC with DENY action followed by a RBAC with ALLOW action. ");
        LinkedHashMap<String, Expr> denyConditions = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Policy> policy : denyPolicy.getPolicies().entrySet()) {
            denyConditions.put(policy.getKey(), policy.getValue().getCondition());
        }
        this.denyEngine = new RbacEngine(RBAC.Action.DENY, (ImmutableMap<String, Expr>)ImmutableMap.copyOf(denyConditions));
        LinkedHashMap<String, Expr> allowConditions = new LinkedHashMap<String, Expr>();
        for (Map.Entry<String, Policy> policy : allowPolicy.getPolicies().entrySet()) {
            allowConditions.put(policy.getKey(), policy.getValue().getCondition());
        }
        this.allowEngine = new RbacEngine(RBAC.Action.ALLOW, (ImmutableMap<String, Expr>)ImmutableMap.copyOf(allowConditions));
    }

    public AuthorizationDecision evaluate(EvaluateArgs args) {
        AuthorizationDecision authzDecision;
        ArrayList<String> unknownPolicyNames = new ArrayList<String>();
        Activation activation = Activation.copyOf(args.generateEnvoyAttributes());
        if (this.denyEngine != null) {
            authzDecision = this.evaluateEngine((Set<Map.Entry<String, Expr>>)this.denyEngine.conditions.entrySet(), AuthorizationDecision.Output.DENY, unknownPolicyNames, activation);
            if (authzDecision != null) {
                return authzDecision;
            }
            if (!unknownPolicyNames.isEmpty()) {
                return new AuthorizationDecision(AuthorizationDecision.Output.UNKNOWN, unknownPolicyNames);
            }
        }
        if (this.allowEngine != null) {
            authzDecision = this.evaluateEngine((Set<Map.Entry<String, Expr>>)this.allowEngine.conditions.entrySet(), AuthorizationDecision.Output.ALLOW, unknownPolicyNames, activation);
            if (authzDecision != null) {
                return authzDecision;
            }
            if (!unknownPolicyNames.isEmpty()) {
                return new AuthorizationDecision(AuthorizationDecision.Output.UNKNOWN, unknownPolicyNames);
            }
        }
        if (this.allowEngine == null && this.denyEngine != null) {
            return new AuthorizationDecision(AuthorizationDecision.Output.ALLOW, new ArrayList<String>());
        }
        return new AuthorizationDecision(AuthorizationDecision.Output.DENY, new ArrayList<String>());
    }

    protected AuthorizationDecision evaluateEngine(Set<Map.Entry<String, Expr>> entrySet, AuthorizationDecision.Output decision, List<String> unknownPolicyNames, Activation activation) {
        for (Map.Entry<String, Expr> condition : entrySet) {
            try {
                if (!this.matches(condition.getValue(), activation)) continue;
                return new AuthorizationDecision(decision, new ArrayList<String>(Arrays.asList(condition.getKey())));
            }
            catch (InterpreterException e) {
                unknownPolicyNames.add(condition.getKey());
            }
        }
        return null;
    }

    protected boolean matches(Expr condition, Activation activation) throws InterpreterException {
        ArrayList<Descriptors.Descriptor> descriptors = new ArrayList<Descriptors.Descriptor>();
        DescriptorMessageProvider messageProvider = DescriptorMessageProvider.dynamicMessages(descriptors);
        DefaultDispatcher dispatcher = DefaultDispatcher.create();
        DefaultInterpreter interpreter = new DefaultInterpreter(messageProvider, dispatcher);
        Interpretable interpretable = interpreter.createInterpretable(condition);
        try {
            Object result = interpretable.eval(activation);
            if (result instanceof Boolean) {
                return Boolean.parseBoolean(result.toString());
            }
            if (result instanceof IncompleteData) {
                throw new InterpreterException.Builder("Envoy Attributes gotten are incomplete.", new Object[0]).build();
            }
        }
        catch (InterpreterException e) {
            log.log(Level.WARNING, e.toString(), e);
            throw e;
        }
        return false;
    }

    private static class RbacEngine {
        private final RBAC.Action action;
        private final ImmutableMap<String, Expr> conditions;

        public RbacEngine(RBAC.Action action, ImmutableMap<String, Expr> conditions) {
            this.action = (RBAC.Action)((Object)Preconditions.checkNotNull((Object)((Object)action)));
            this.conditions = (ImmutableMap)Preconditions.checkNotNull(conditions);
        }
    }
}

