/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestReflectionUtils {
    @Test
    public void testForNameClassNotFound() {
        try {
            ReflectionUtils.forName((String)"test.for.name.class.not.found", Object.class);
            Assert.fail((String)"Should fail if class not found");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof ClassNotFoundException));
        }
    }

    @Test
    public void testForNameUnassignable() {
        try {
            ReflectionUtils.forName((String)ClassA.class.getName(), InterfaceB.class);
            Assert.fail((String)"Should fail if class is not assignable");
        }
        catch (RuntimeException re) {
            Assert.assertEquals((Object)(ClassA.class.getName() + " not " + InterfaceB.class.getName()), (Object)re.getMessage());
        }
    }

    @Test
    public void testForName() throws Exception {
        Class theCls = ReflectionUtils.forName((String)ClassB.class.getName(), InterfaceB.class);
        Assert.assertEquals(ClassB.class, (Object)theCls);
    }

    private static class ClassB
    implements InterfaceB {
        private ClassB() {
        }
    }

    private static class ClassA
    implements InterfaceA {
        private ClassA() {
        }
    }

    static interface InterfaceB {
    }

    static interface InterfaceA {
    }
}

