/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOrderedExecutorDecorators {
    private static final Logger log = LoggerFactory.getLogger(TestOrderedExecutorDecorators.class);
    private static final String MDC_KEY = "mdc-key";
    private Appender mockAppender;
    private final Queue<String> capturedEvents = new ConcurrentLinkedQueue<String>();

    public static String mdcFormat(Object mdc, String message) {
        return String.format("[%s:%s] %s", MDC_KEY, mdc, message);
    }

    @Before
    public void setUp() throws Exception {
        MDC.clear();
        this.mockAppender = (Appender)Mockito.mock(Appender.class);
        Mockito.when((Object)this.mockAppender.getName()).thenReturn((Object)"MockAppender");
        LogManager.getRootLogger().addAppender(this.mockAppender);
        LogManager.getRootLogger().setLevel(Level.INFO);
        ((Appender)Mockito.doAnswer((Answer)AdditionalAnswers.answerVoid(event -> this.capturedEvents.add(TestOrderedExecutorDecorators.mdcFormat(event.getMDC(MDC_KEY), event.getRenderedMessage())))).when((Object)this.mockAppender)).doAppend((LoggingEvent)ArgumentMatchers.any());
    }

    @After
    public void tearDown() throws Exception {
        LogManager.getRootLogger().removeAppender(this.mockAppender);
        this.capturedEvents.clear();
        MDC.clear();
    }

    @Test
    public void testMDCInvokeOrdered() throws Exception {
        OrderedExecutor executor = OrderedExecutor.newBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            MDC.put((String)MDC_KEY, (Object)"testMDCInvokeOrdered");
            executor.submitOrdered(10L, () -> {
                log.info("foobar");
                return 10;
            }).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testMDCInvokeDirectOnChosen() throws Exception {
        OrderedExecutor executor = OrderedExecutor.newBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            MDC.put((String)MDC_KEY, (Object)"testMDCInvokeOrdered");
            executor.chooseThread(10L).submit(() -> {
                log.info("foobar");
                return 10;
            }).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            executor.shutdown();
        }
    }

    @Test
    public void testMDCScheduleOrdered() throws Exception {
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            MDC.put((String)MDC_KEY, (Object)"testMDCInvokeOrdered");
            scheduler.scheduleOrdered((Object)10, SafeRunnable.safeRun(() -> log.info("foobar")), 0L, TimeUnit.DAYS).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            scheduler.shutdown();
        }
    }

    @Test
    public void testMDCScheduleDirectOnChosen() throws Exception {
        OrderedScheduler scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().name("test").numThreads(20).preserveMdcForTaskExecution(true).build();
        try {
            MDC.put((String)MDC_KEY, (Object)"testMDCInvokeOrdered");
            scheduler.chooseThread(10L).schedule((Runnable)SafeRunnable.safeRun(() -> log.info("foobar")), 0L, TimeUnit.DAYS).get();
            Assert.assertThat(this.capturedEvents, (Matcher)Matchers.hasItem((Object)TestOrderedExecutorDecorators.mdcFormat("testMDCInvokeOrdered", "foobar")));
        }
        finally {
            scheduler.shutdown();
        }
    }
}

