/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.allocator.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ByteBufAllocatorBuilderTest {
    private static final OutOfMemoryError outOfDirectMemException;

    @Test
    public void testOomWithException() {
        ByteBufAllocator baseAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Mockito.when((Object)baseAlloc.directBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{outOfDirectMemException});
        AtomicReference receivedException = new AtomicReference();
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().pooledAllocator(baseAlloc).outOfMemoryPolicy(OutOfMemoryPolicy.ThrowException).outOfMemoryListener(e -> receivedException.set(e)).build();
        try {
            alloc.buffer();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (OutOfMemoryError e2) {
            Assert.assertEquals((Object)outOfDirectMemException, (Object)e2);
        }
        Assert.assertEquals((Object)outOfDirectMemException, receivedException.get());
    }

    @Test
    public void testOomWithFallback() {
        ByteBufAllocator baseAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Mockito.when((Object)baseAlloc.directBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{outOfDirectMemException});
        AtomicReference receivedException = new AtomicReference();
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().pooledAllocator(baseAlloc).unpooledAllocator((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT).outOfMemoryPolicy(OutOfMemoryPolicy.FallbackToHeap).outOfMemoryListener(e -> receivedException.set(e)).build();
        ByteBuf buf = alloc.buffer();
        Assert.assertEquals((Object)UnpooledByteBufAllocator.DEFAULT, (Object)buf.alloc());
        Assert.assertEquals(null, receivedException.get());
    }

    @Test
    public void testOomWithFallbackAndNoMoreHeap() {
        ByteBufAllocator baseAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        Mockito.when((Object)baseAlloc.directBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{outOfDirectMemException});
        ByteBufAllocator heapAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        OutOfMemoryError noHeapError = new OutOfMemoryError("no more heap");
        Mockito.when((Object)heapAlloc.heapBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{noHeapError});
        AtomicReference receivedException = new AtomicReference();
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().pooledAllocator(baseAlloc).unpooledAllocator(heapAlloc).outOfMemoryPolicy(OutOfMemoryPolicy.FallbackToHeap).outOfMemoryListener(e -> receivedException.set(e)).build();
        try {
            alloc.buffer();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (OutOfMemoryError e2) {
            Assert.assertEquals((Object)noHeapError, (Object)e2);
        }
        Assert.assertEquals((Object)noHeapError, receivedException.get());
    }

    @Test
    public void testOomUnpooledDirect() {
        ByteBufAllocator heapAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        OutOfMemoryError noMemError = new OutOfMemoryError("no more direct mem");
        Mockito.when((Object)heapAlloc.directBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{noMemError});
        AtomicReference receivedException = new AtomicReference();
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().poolingPolicy(PoolingPolicy.UnpooledHeap).unpooledAllocator(heapAlloc).outOfMemoryPolicy(OutOfMemoryPolicy.FallbackToHeap).outOfMemoryListener(e -> receivedException.set(e)).build();
        try {
            alloc.directBuffer();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (OutOfMemoryError e2) {
            Assert.assertEquals((Object)noMemError, (Object)e2);
        }
        Assert.assertEquals((Object)noMemError, receivedException.get());
    }

    @Test
    public void testOomUnpooledWithHeap() {
        ByteBufAllocator heapAlloc = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);
        OutOfMemoryError noHeapError = new OutOfMemoryError("no more heap");
        Mockito.when((Object)heapAlloc.heapBuffer(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{noHeapError});
        AtomicReference receivedException = new AtomicReference();
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().poolingPolicy(PoolingPolicy.UnpooledHeap).unpooledAllocator(heapAlloc).outOfMemoryPolicy(OutOfMemoryPolicy.FallbackToHeap).outOfMemoryListener(e -> receivedException.set(e)).build();
        try {
            alloc.heapBuffer();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (OutOfMemoryError e2) {
            Assert.assertEquals((Object)noHeapError, (Object)e2);
        }
        Assert.assertEquals((Object)noHeapError, receivedException.get());
    }

    @Test
    public void testUnpooled() {
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().poolingPolicy(PoolingPolicy.UnpooledHeap).build();
        ByteBuf buf = alloc.buffer();
        Assert.assertEquals((Object)UnpooledByteBufAllocator.DEFAULT, (Object)buf.alloc());
        Assert.assertTrue((boolean)buf.hasArray());
        ByteBuf buf2 = alloc.directBuffer();
        Assert.assertEquals((Object)UnpooledByteBufAllocator.DEFAULT, (Object)buf2.alloc());
        Assert.assertFalse((boolean)buf2.hasArray());
    }

    @Test
    public void testPooled() {
        PooledByteBufAllocator pooledAlloc = new PooledByteBufAllocator(true);
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().poolingPolicy(PoolingPolicy.PooledDirect).pooledAllocator((ByteBufAllocator)pooledAlloc).build();
        Assert.assertTrue((boolean)alloc.isDirectBufferPooled());
        ByteBuf buf1 = alloc.buffer();
        Assert.assertEquals((Object)pooledAlloc, (Object)buf1.alloc());
        Assert.assertFalse((boolean)buf1.hasArray());
        buf1.release();
        ByteBuf buf2 = alloc.directBuffer();
        Assert.assertEquals((Object)pooledAlloc, (Object)buf2.alloc());
        Assert.assertFalse((boolean)buf2.hasArray());
        buf2.release();
        ByteBuf buf3 = alloc.heapBuffer();
        Assert.assertEquals((Object)pooledAlloc, (Object)buf3.alloc());
        Assert.assertTrue((boolean)buf3.hasArray());
        buf3.release();
    }

    @Test
    public void testPooledWithDefaultAllocator() {
        ByteBufAllocator alloc = ByteBufAllocatorBuilder.create().poolingPolicy(PoolingPolicy.PooledDirect).poolingConcurrency(3).build();
        Assert.assertTrue((boolean)alloc.isDirectBufferPooled());
        ByteBuf buf1 = alloc.buffer();
        Assert.assertEquals(PooledByteBufAllocator.class, buf1.alloc().getClass());
        Assert.assertEquals((long)3L, (long)((PooledByteBufAllocator)buf1.alloc()).metric().numDirectArenas());
        Assert.assertFalse((boolean)buf1.hasArray());
        buf1.release();
        ByteBuf buf2 = alloc.directBuffer();
        Assert.assertFalse((boolean)buf2.hasArray());
        buf2.release();
        ByteBuf buf3 = alloc.heapBuffer();
        Assert.assertTrue((boolean)buf3.hasArray());
        buf3.release();
    }

    static {
        try {
            Class<?> clazz = ByteBufAllocatorBuilderTest.class.getClassLoader().loadClass("io.netty.util.internal.OutOfDirectMemoryError");
            Constructor<?> constructor = clazz.getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            outOfDirectMemException = (OutOfMemoryError)constructor.newInstance("no mem");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

