/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.grpc.resolver;

import com.google.common.collect.Lists;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.common.resolver.NameResolverFactoryProvider;
import org.apache.bookkeeper.common.resolver.NameResolverProviderFactory;
import org.apache.bookkeeper.grpc.resolver.BKRegistrationNameResolver;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKRegistrationNameResolverProvider
extends NameResolverFactoryProvider {
    private static final Logger log = LoggerFactory.getLogger(BKRegistrationNameResolverProvider.class);

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 100;
    }

    @Nullable
    public NameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        ServiceURI serviceURI;
        try {
            serviceURI = ServiceURI.create((URI)targetUri);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.info("BKRegistrationNameResolverProvider doesn't know how to resolve {} : cause {}", (Object)targetUri, (Object)e.getMessage());
            return null;
        }
        try {
            MetadataClientDriver clientDriver = MetadataDrivers.getClientDriver((URI)serviceURI.getUri());
            return new BKRegistrationNameResolver(clientDriver, serviceURI.getUri());
        }
        catch (IllegalArgumentException iae) {
            log.error("Unknown service uri : {}", (Object)serviceURI, (Object)iae);
            return null;
        }
    }

    public String getDefaultScheme() {
        return "zk";
    }

    public NameResolver.Factory toFactory() {
        return new NameResolverProviderFactory((List)Lists.newArrayList((Object[])new NameResolverProvider[]{this}));
    }
}

