/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.grpc.resolver;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.DefaultBookieAddressResolver;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

class BKRegistrationNameResolver
extends NameResolver {
    private final MetadataClientDriver clientDriver;
    private final URI serviceURI;
    private final ScheduledExecutorService executor;
    private NameResolver.Listener listener;
    private boolean shutdown;
    private boolean resolving;
    private DefaultBookieAddressResolver bookieAddressResolver;

    BKRegistrationNameResolver(MetadataClientDriver clientDriver, URI serviceURI) {
        this.clientDriver = clientDriver;
        this.serviceURI = serviceURI;
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("registration-name-resolver").build());
    }

    public String getServiceAuthority() {
        return this.serviceURI.getAuthority();
    }

    public synchronized void start(NameResolver.Listener listener) {
        Preconditions.checkState((null == this.listener ? 1 : 0) != 0, (Object)"Resolver already started");
        this.listener = Objects.requireNonNull(listener, "Listener is null");
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.serviceURI.toString());
        try {
            this.clientDriver.initialize(conf, this.executor, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
        }
        catch (MetadataException e) {
            throw new RuntimeException("Failed to initialize registration client driver at " + this.serviceURI, e);
        }
        this.bookieAddressResolver = new DefaultBookieAddressResolver(this.clientDriver.getRegistrationClient());
        this.resolve();
    }

    private synchronized void resolve() {
        if (this.resolving || this.shutdown) {
            return;
        }
        this.resolving = true;
        this.clientDriver.getRegistrationClient().watchWritableBookies(bookies -> {
            NameResolver.Listener savedListener;
            BKRegistrationNameResolver bKRegistrationNameResolver = this;
            synchronized (bKRegistrationNameResolver) {
                savedListener = this.listener;
            }
            savedListener.onAddresses(this.hostsToEquivalentAddressGroups((Set)bookies.getValue()), Attributes.EMPTY);
        }).whenComplete((ignored, cause) -> {
            try {
                if (null != cause) {
                    this.resolve();
                }
            }
            finally {
                BKRegistrationNameResolver bKRegistrationNameResolver = this;
                synchronized (bKRegistrationNameResolver) {
                    this.resolving = false;
                }
            }
        });
    }

    private List<EquivalentAddressGroup> hostsToEquivalentAddressGroups(Set<BookieId> bookies) {
        return bookies.stream().map(addr -> new EquivalentAddressGroup(Collections.singletonList(this.bookieAddressResolver.resolve(addr).getSocketAddress()), Attributes.EMPTY)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        BKRegistrationNameResolver bKRegistrationNameResolver = this;
        synchronized (bKRegistrationNameResolver) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        this.executor.shutdown();
        this.clientDriver.close();
    }
}

