/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.server;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.server.RmiFacade;

public class RmiProtocol {
    public static final int ERROR_CODE_INVALID_JSON = -32700;
    public static final int ERROR_CODE_INVALID_REQUEST = -32600;
    public static final int ERROR_CODE_METHOD_NOT_FOUND = -32601;
    public static final int ERROR_CODE_INVALID_PARAMS = -32602;
    public static final int ERROR_CODE_JSONRPC_ERROR = -32603;
    public static final int ERROR_CODE_SERVER_ERROR = -32000;
    public static final int ERROR_CODE_OBJECT_NOT_FOUND = -32004;
    protected static final String VERSION = "0.1.rmi";
    private static final Gson GSON = new Gson();
    private final String objectId;
    private final RmiFacade rmi;

    public RmiProtocol(String objectId, RmiFacade rmi) {
        this.objectId = objectId;
        this.rmi = rmi;
    }

    public String invoke(String invocationJson) {
        MethodInvocationDto invocation;
        try {
            invocation = (MethodInvocationDto)GSON.fromJson(invocationJson, MethodInvocationDto.class);
        }
        catch (JsonSyntaxException e) {
            String details = e.getMessage() + " in JSON: '" + invocationJson + "'";
            return this.marshall(GSON, new MethodInvocationResultDto(-32700, "Invalid JSON", details), null);
        }
        if (!this.isSupportedProtocol(invocation)) {
            String message = "Unsupported protocol version";
            String version = invocation.getJsonrpc();
            return this.marshall(GSON, new MethodInvocationResultDto(-32603, message, version), invocation);
        }
        if (!this.isValidRequest(invocation)) {
            return this.marshall(GSON, new MethodInvocationResultDto(-32600, "Invalid Request", invocationJson), invocation);
        }
        MethodInvocationResultDto result = this.rmi.invoke(this.objectId, invocation);
        return this.marshall(GSON, result, invocation);
    }

    private boolean isSupportedProtocol(MethodInvocationDto invocation) {
        String version = invocation.getJsonrpc();
        return version == null || version.equals(VERSION);
    }

    private boolean isValidRequest(MethodInvocationDto invocation) {
        String method = invocation.getMethod();
        return method != null && !method.isEmpty();
    }

    private String marshall(Gson gson, MethodInvocationResultDto result, MethodInvocationDto invocation) {
        result.setJsonrpc(VERSION);
        result.setId("" + null);
        if (invocation != null) {
            result.setId(invocation.getId());
        }
        return gson.toJson((Object)result);
    }
}

