/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.client.ClassAdapter;
import io.sterodium.rmi.protocol.client.RestTransport;
import io.sterodium.rmi.protocol.client.RmiTransport;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClient.class);
    private static final Gson GSON;
    private final RmiTransport transport;

    public RestClient(String host, int port, String path) {
        this.transport = new RestTransport(host, port, path);
    }

    public RestClient(RmiTransport transport) {
        this.transport = transport;
    }

    public String invoke(String remoteObjectId, MethodInvocationDto methodInvocationDto) throws IOException {
        String json = GSON.toJson((Object)methodInvocationDto);
        LOGGER.info("Request: " + json);
        String response = this.transport.send(remoteObjectId, json);
        LOGGER.info("Response: " + response);
        return response;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Class.class, (Object)new ClassAdapter());
        GSON = gsonBuilder.create();
    }
}

