/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import com.google.common.base.Preconditions;
import io.sterodium.rmi.protocol.client.RemoteInvoker;
import io.sterodium.rmi.protocol.client.RemoteObjectMethodInterceptor;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.Predicate;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import org.objenesis.ObjenesisStd;

class RemoteObjectProxyFactory {
    private static Map<Object, String> widgetIds = new HashMap<Object, String>();
    private RemoteInvoker invoker;
    private static final NamingPolicy NAMING_POLICY_FOR_CLASSES_IN_SIGNED_PACKAGES = new DefaultNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };

    public RemoteObjectProxyFactory(RemoteInvoker invoker) {
        this.invoker = invoker;
    }

    public void setInvoker(RemoteInvoker invoker) {
        this.invoker = invoker;
    }

    public <T> T create(Class<T> clazz, String widgetId) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(clazz);
        enhancer.setUseFactory(true);
        enhancer.setCallbackType(RemoteObjectMethodInterceptor.class);
        if (clazz.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_FOR_CLASSES_IN_SIGNED_PACKAGES);
        }
        Class proxyClass = enhancer.createClass();
        ObjenesisStd objenesis = new ObjenesisStd();
        Factory proxy = (Factory)objenesis.newInstance(proxyClass);
        proxy.setCallbacks(new Callback[]{new RemoteObjectMethodInterceptor(this, this.invoker, widgetId)});
        Factory widget = proxy;
        widgetIds.put(widget, widgetId);
        return (T)widget;
    }

    public <T> T castWidgetTo(Object widget, Class<T> clazz) {
        String errorMessage = "Given widget has not been created by instance of current " + RemoteObjectProxyFactory.class.getSimpleName();
        Preconditions.checkArgument((boolean)Enhancer.isEnhanced(widget.getClass()), (Object)errorMessage);
        String widgetId = widgetIds.get(widget);
        return this.create(clazz, widgetId);
    }

    public void reset() {
        widgetIds.clear();
    }

    public static boolean isProxy(Object proxyCandidate) {
        return widgetIds.get(proxyCandidate) != null;
    }

    public static String getObjectId(Object proxy) {
        return widgetIds.get(proxy);
    }
}

