/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.server;

import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.server.Marshaller;
import io.sterodium.rmi.protocol.server.MethodInvoker;
import io.sterodium.rmi.protocol.server.ObjectLocator;
import io.sterodium.rmi.protocol.server.RemoteMethodInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiFacade {
    private static final Logger LOG = LoggerFactory.getLogger(RmiFacade.class);
    private ObjectLocator objectLocator = new ObjectLocator();
    private Marshaller marshaller = new Marshaller(this.objectLocator);
    private MethodInvoker invoker = new MethodInvoker(this.objectLocator);

    public MethodInvocationResultDto invoke(String objectId, MethodInvocationDto invocation) {
        Object result;
        Object object = this.objectLocator.get(objectId);
        if (object == null) {
            LOG.error("Object ({}) not found. Please make sure objects cache size (for objects chained invocation).", (Object)objectId);
        }
        Class<?> returnType = null;
        try {
            MethodInvoker.InvocationResult invocationResult = this.invoker.invoke(object, invocation);
            result = invocationResult.getResult();
            returnType = invocationResult.getResultClass();
        }
        catch (RuntimeException e) {
            throw new RemoteMethodInvocationException(e.getMessage(), e);
        }
        return this.marshaller.toResponse(result, returnType);
    }

    public void add(String objectId, Object object) {
        this.objectLocator.addPermanentObject(objectId, object);
    }
}

