/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.server;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.server.ClassUtils;
import io.sterodium.rmi.protocol.server.ObjectLocator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class MethodInvoker {
    private static final Logger LOGGER = Logger.getLogger(MethodInvoker.class.getName());
    private static final Map<Class<?>, Class<?>> IMPLEMENTATIONS = Maps.newHashMap();
    private final Gson gson = new Gson();
    private ObjectLocator objectLocator;

    public MethodInvoker(ObjectLocator objectLocator) {
        this.objectLocator = objectLocator;
    }

    public InvocationResult invoke(Object target, MethodInvocationDto invocation) {
        String methodName = invocation.getMethod();
        LOGGER.info("*** Calling " + methodName + " on " + target.getClass().getName());
        Class<?>[] parameterTypes = this.toClasses(invocation.getArgumentClasses());
        Object[] arguments = this.toObjects(invocation.getArguments(), parameterTypes);
        Method method = this.getMethod(target, methodName, parameterTypes);
        Object result = this.invoke(target, method, arguments);
        Class<?> returnType = method.getReturnType();
        return new InvocationResult(result, returnType);
    }

    protected Class<?>[] toClasses(String[] argumentClassesNames) {
        Class[] argumentClasses = new Class[argumentClassesNames.length];
        for (int i = 0; i < argumentClasses.length; ++i) {
            try {
                argumentClasses[i] = ClassUtils.forName(argumentClassesNames[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Class " + argumentClassesNames[i] + " not found");
            }
        }
        return argumentClasses;
    }

    protected Object[] toObjects(String[] argumentStrings, Class<?>[] parameterTypes) {
        Object[] arguments = new Object[argumentStrings.length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = this.toObject(argumentStrings[i], parameterTypes[i]);
        }
        return arguments;
    }

    private Object toObject(String value, Class<?> targetClass) {
        if (String.class.equals(targetClass)) {
            return value;
        }
        if (Integer.TYPE.equals(targetClass) || Integer.class.equals(targetClass)) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(targetClass) || Long.class.equals(targetClass)) {
            return Long.valueOf(value);
        }
        if (Character.TYPE.equals(targetClass) || Character.class.equals(targetClass)) {
            return Character.valueOf(value.toCharArray()[0]);
        }
        if (Class.class.equals(targetClass)) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (targetClass.isArray()) {
            Class<?> componentType = targetClass.getComponentType();
            if (componentType.isInterface()) {
                componentType = IMPLEMENTATIONS.get(componentType);
            }
            try {
                Class<?> arrayType = Class.forName("[L" + componentType.getName() + ";");
                return this.gson.fromJson(value, arrayType);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Could not find class for array of '%s'", componentType.getName()));
            }
        }
        Object object = this.objectLocator.get(value);
        if (object != null) {
            return object;
        }
        throw new RuntimeException(String.format("Class %s is not supported as method parameter", targetClass));
    }

    protected Method getMethod(Object target, String methodName, Class<?>[] parameterTypes) {
        try {
            Class<?> targetClass = target.getClass().equals(Class.class) ? (Class<?>)target : target.getClass();
            return targetClass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Method %s.%s not found (argument types: %s)", target.getClass().getName(), methodName, Arrays.toString(parameterTypes)));
        }
        catch (SecurityException e) {
            throw new RuntimeException(String.format("Security Exception during method %s.%s call", target.getClass().getName(), methodName));
        }
    }

    private Object invoke(Object target, Method method, Object[] arguments) {
        try {
            boolean publicMethod = Modifier.isPublic(method.getModifiers());
            if (publicMethod) {
                method.setAccessible(true);
            }
            return method.invoke(target, arguments);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Method %s.%s is not accessible", target.getClass().getName(), method.getName()));
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Method %s.%s call is illegal", target.getClass().getName(), method.getName()));
        }
        catch (InvocationTargetException e) {
            String errorMessage = String.format("Method %s.%s threw exception: %s", target.getClass().getName(), method.getName(), e.getCause());
            LOGGER.log(Level.WARNING, errorMessage, e);
            throw new RuntimeException(errorMessage, e);
        }
    }

    static {
        IMPLEMENTATIONS.put(CharSequence.class, String.class);
    }

    protected static class InvocationResult {
        private Object result;
        private Class<?> resultClass;

        public InvocationResult(Object result, Class<?> resultClass) {
            this.result = result;
            this.resultClass = resultClass;
        }

        public Object getResult() {
            return this.result;
        }

        public Class<?> getResultClass() {
            return this.resultClass;
        }
    }
}

