/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.sterodium.rmi.protocol.MethodInvocationDto;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestClient.class);
    private static final Gson GSON;
    private final HttpHost httpHost;
    private HttpClient httpClient = HttpClientBuilder.create().build();
    private String path;

    public RestClient(String host, int port, String path) {
        this.httpHost = new HttpHost(host, port);
        this.path = path;
    }

    public String invoke(String remoteObjectId, MethodInvocationDto methodInvocationDto) throws IOException {
        String jsonString = GSON.toJson((Object)methodInvocationDto);
        LOGGER.info("Invocation request: " + jsonString);
        HttpPost request = new HttpPost(this.path + "/" + URLEncoder.encode(remoteObjectId, "UTF-8"));
        request.setEntity((HttpEntity)new StringEntity(jsonString));
        HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)request);
        int statusCode = this.getStatusCode(httpResponse);
        if (statusCode == 404) {
            throw new RuntimeException(String.format("Widget %s is not available at %s", remoteObjectId, this.getUrl((HttpRequestBase)request)));
        }
        if (statusCode != 200) {
            String messageFromServer = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            throw new RuntimeException(String.format("Widget %s invocation failed (expected 200, but was %s): %s", remoteObjectId, statusCode, messageFromServer));
        }
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    public void reset() throws IOException {
        HttpDelete request = new HttpDelete(this.path);
        HttpResponse httpResponse = this.httpClient.execute(this.httpHost, (HttpRequest)request);
        int statusCode = this.getStatusCode(httpResponse);
        if (statusCode != 200) {
            throw new RuntimeException(String.format("Widgets reset operation failed (expected 200, but was %s)", statusCode));
        }
    }

    private int getStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    private String getUrl(HttpRequestBase request) {
        return String.format("(%s) http://%s%s", request.getMethod(), this.httpHost.toHostString(), request.getURI());
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Class.class, (Object)new ClassAdapter());
        GSON = gsonBuilder.create();
    }

    private static class ClassAdapter
    implements JsonSerializer<Class> {
        private ClassAdapter() {
        }

        public JsonElement serialize(Class clazz, Type type, JsonSerializationContext jsc) {
            return new JsonPrimitive(clazz.getName());
        }
    }
}

