/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import com.google.common.primitives.Primitives;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.client.RemoteInvoker;
import io.sterodium.rmi.protocol.client.RemoteObjectProxyFactory;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteObjectMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteObjectMethodInterceptor.class);
    private RemoteObjectProxyFactory proxyFactory;
    private RemoteInvoker invoker;
    private String widgetId;

    public RemoteObjectMethodInterceptor(RemoteObjectProxyFactory proxyFactory, RemoteInvoker invoker, String widgetId) {
        this.proxyFactory = proxyFactory;
        this.invoker = invoker;
        this.widgetId = widgetId;
    }

    public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return methodProxy.invokeSuper(proxy, arguments);
        }
        if ("toString".equals(method.getName()) && arguments.length == 0) {
            return methodProxy.invokeSuper(proxy, arguments);
        }
        return this.invoke(method, arguments);
    }

    Object invoke(Method method, Object[] arguments) {
        try {
            MethodInvocationResultDto methodResponse = this.invoker.invoke(this.widgetId, method, arguments);
            LOGGER.info("Response: " + methodResponse.toString());
            String responseValue = methodResponse.getValue();
            return responseValue == null ? null : this.convertToType(responseValue, method.getReturnType(), methodResponse.getType());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unmapped response", (Throwable)e);
            return null;
        }
    }

    private Object convertToType(String response, Class<?> type, String responseType) throws ClassNotFoundException {
        LOGGER.info(String.format("Converting response '%s' to type %s or %s", response, type, responseType));
        if (this.isVoid(type)) {
            return null;
        }
        if (String.class.equals(type)) {
            return response;
        }
        if (this.isNotVoidPrimitive(type)) {
            return this.parseString(response, type);
        }
        return this.proxyFactory.create(Class.forName(responseType), response);
    }

    boolean isVoid(Class<?> returnType) {
        return Void.TYPE.equals(returnType) || Void.class.equals(returnType);
    }

    boolean isNotVoidPrimitive(Class<?> type) {
        return !this.isVoid(type) && (type.isPrimitive() || Primitives.isWrapperType(type));
    }

    Object parseString(String value, Class<?> type) {
        try {
            Class targetType = Primitives.wrap(type);
            return targetType.getConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse string and construct object", (Throwable)e);
            return null;
        }
    }
}

