/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.log;

import io.sterodium.extensions.spi.GridConfigurator;
import java.io.File;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfigurator
implements GridConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConfigurator.class);
    private static final String LOG_FILE_PARAM = "-log";
    private static final String LOG_FILE_PROPERTY = "selenium.LOGGER";
    private static final String LOG_LEVEL_PROPERTY = "selenium.LOGGER.level";
    private static final String PATTERN = "%d{ISO8601} [%t] [%p] [%c] %m%n";
    private static final String MAX_FILE_SIZE = "10MB";
    private static final int MAX_BACKUPS = 1;
    private Level logLevel;

    public String[] configure(String[] args) {
        boolean isLog4jConfigured = org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements();
        if (!isLog4jConfigured) {
            this.logLevel = Arrays.asList(args).contains("-debug") ? Level.DEBUG : LoggingConfigurator.getDefaultLogLevel();
            String logFilename = LoggingConfigurator.getLogFilename(args);
            if (logFilename != null && !logFilename.isEmpty()) {
                this.installFileAppender(logFilename);
            } else {
                this.installConsoleAppender();
                LOG.info("No logging configuration found, logging to console");
            }
        }
        return LoggingConfigurator.clearLogFilenameParam(args);
    }

    private void installConsoleAppender() {
        ConsoleAppender console = new ConsoleAppender();
        console.setName("Console");
        console.setThreshold(this.logLevel);
        console.setLayout(new PatternLayout(PATTERN));
        console.setFollow(true);
        console.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(console);
    }

    private void installFileAppender(String logFilename) {
        RollingFileAppender file = new RollingFileAppender();
        file.setName("FileAppender");
        file.setThreshold(this.logLevel);
        file.setFile(new File(logFilename).getAbsolutePath());
        file.setMaxFileSize(MAX_FILE_SIZE);
        file.setMaxBackupIndex(1);
        file.setLayout(new PatternLayout(PATTERN));
        file.setAppend(true);
        file.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(file);
    }

    private static String getLogFilename(String[] args) {
        int idx = Arrays.asList(args).indexOf(LOG_FILE_PARAM);
        String logFilename = -1 != idx ? args[idx + 1] : LoggingConfigurator.getLogFilenameFromSystemProperty();
        return logFilename;
    }

    private static String[] clearLogFilenameParam(String[] args) {
        System.clearProperty(LOG_FILE_PROPERTY);
        int idx = Arrays.asList(args).indexOf(LOG_FILE_PARAM);
        if (-1 != idx) {
            if (args.length > idx + 1) {
                args = (String[])ArrayUtils.remove((Object[])args, (int)(idx + 1));
            }
            args = (String[])ArrayUtils.remove((Object[])args, (int)idx);
        }
        return args;
    }

    private static String getLogFilenameFromSystemProperty() {
        String logFilename = System.getProperty(LOG_FILE_PROPERTY);
        if (null == logFilename) {
            return null;
        }
        return new File(logFilename).getAbsolutePath();
    }

    private static Level getDefaultLogLevel() {
        String logLevelProperty = System.getProperty(LOG_LEVEL_PROPERTY);
        if (null == logLevelProperty) {
            return Level.INFO;
        }
        return Level.toLevel(logLevelProperty);
    }
}

