/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.extensions.log;

import io.sterodium.extensions.common.CommandLineOptionManager;
import io.sterodium.extensions.spi.GridConfigurator;
import java.io.File;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfigurator
implements GridConfigurator {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConfigurator.class);
    private static final String LOG_FILE_PARAM = "-log";
    private static final String LOG_FILE_PROPERTY = "selenium.LOGGER";
    private static final String LOG_LEVEL_PROPERTY = "selenium.LOGGER.level";
    private static final String PATTERN = "%d{ISO8601} [%t] [%p] [%c] %m%n";
    private static final String MAX_FILE_SIZE = "10MB";
    private static final int MAX_BACKUPS = 1;
    private CommandLineOptionManager commandLineOptionManager;
    private Level logLevel;

    public String[] configure(String[] args) {
        this.commandLineOptionManager = new CommandLineOptionManager(args);
        boolean isLog4jConfigured = org.apache.log4j.Logger.getRootLogger().getAllAppenders().hasMoreElements();
        if (!isLog4jConfigured) {
            this.logLevel = this.commandLineOptionManager.isParamPresent("-debug") ? Level.DEBUG : LoggingConfigurator.getDefaultLogLevel();
            String logFilename = this.getLogFilename();
            if (logFilename != null && !logFilename.isEmpty()) {
                this.installFileAppender(logFilename);
            } else {
                this.installConsoleAppender();
                LOG.info("No logging configuration found, logging to console");
            }
        }
        this.clearLogFilenameParam();
        return this.commandLineOptionManager.getAllParams();
    }

    private void installConsoleAppender() {
        ConsoleAppender console = new ConsoleAppender();
        console.setName("Console");
        console.setThreshold(this.logLevel);
        console.setLayout(new PatternLayout(PATTERN));
        console.setFollow(true);
        console.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(console);
    }

    private void installFileAppender(String logFilename) {
        RollingFileAppender file = new RollingFileAppender();
        file.setName("FileAppender");
        file.setThreshold(this.logLevel);
        file.setFile(new File(logFilename).getAbsolutePath());
        file.setMaxFileSize(MAX_FILE_SIZE);
        file.setMaxBackupIndex(1);
        file.setLayout(new PatternLayout(PATTERN));
        file.setAppend(true);
        file.activateOptions();
        org.apache.log4j.Logger.getRootLogger().addAppender(file);
    }

    private String getLogFilename() {
        String logFilename = this.commandLineOptionManager.isParamPresent(LOG_FILE_PARAM) ? this.commandLineOptionManager.getParamValue(LOG_FILE_PARAM) : LoggingConfigurator.getLogFilenameFromSystemProperty();
        return logFilename;
    }

    private void clearLogFilenameParam() {
        this.commandLineOptionManager.removeParam(LOG_FILE_PARAM);
        System.clearProperty(LOG_FILE_PROPERTY);
    }

    private static String getLogFilenameFromSystemProperty() {
        String logFilename = System.getProperty(LOG_FILE_PROPERTY);
        if (null == logFilename) {
            return null;
        }
        return new File(logFilename).getAbsolutePath();
    }

    private static Level getDefaultLogLevel() {
        String logLevelProperty = System.getProperty(LOG_LEVEL_PROPERTY);
        if (null == logLevelProperty) {
            return Level.INFO;
        }
        return Level.toLevel(logLevelProperty);
    }
}

