/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.search;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.core.cv.ImagePreprocessor;
import org.sikuli.core.search.internal.TemplateMatchingUtilities;

public class TemplateMatcher {
    public static List<Result> findMatchesByGrayscaleAtOriginalResolution(BufferedImage input, BufferedImage target, int limit, double minScore) {
        opencv_core.IplImage input1 = ImagePreprocessor.createGrayscale(input);
        opencv_core.IplImage target1 = ImagePreprocessor.createGrayscale(target);
        opencv_core.IplImage resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrix(input1, target1);
        List<Result> result = TemplateMatcher.fetchMatches(resultMatrix, target1, limit, minScore);
        input1.release();
        target1.release();
        resultMatrix.release();
        return result;
    }

    public static List<Result> findMatchesByGrayscaleAtOriginalResolutionWithROIs(BufferedImage input, BufferedImage target, int limit, double minScore, List<Rectangle> rois) {
        opencv_core.IplImage input1 = ImagePreprocessor.createGrayscale(input);
        opencv_core.IplImage target1 = ImagePreprocessor.createGrayscale(target);
        opencv_core.IplImage resultMatrix = TemplateMatchingUtilities.computeTemplateMatchResultMatrixWithMultipleROIs(input1, target1, rois);
        return TemplateMatcher.fetchMatches(resultMatrix, target1, limit, minScore);
    }

    private static List<Result> fetchMatches(opencv_core.IplImage resultMatrix, opencv_core.IplImage target, int limit, double minScore) {
        ArrayList<Result> matches = Lists.newArrayList();
        while (matches.size() < limit) {
            TemplateMatchingUtilities.TemplateMatchResult result = TemplateMatchingUtilities.fetchNextBestMatch(resultMatrix, target);
            Result m = new Result(result);
            m.setScore(result.score);
            if (!(m.getScore() >= minScore)) break;
            matches.add(m);
        }
        return matches;
    }

    public static class Result {
        public int x;
        public int y;
        public int width;
        public int height;
        private double score;

        public Result(Rectangle r) {
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public Point getLocation() {
            return this.getBounds().getLocation();
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double score) {
            this.score = score;
        }
    }
}

