/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.core.cv;

import com.google.common.collect.Lists;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.helper.opencv_imgproc;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.core.draw.BlobPainter;
import org.sikuli.core.logging.ImageExplainer;

public class VisionUtils {
    static ImageExplainer explainer = ImageExplainer.getExplainer(VisionUtils.class);

    public static BufferedImage createComponentImage(Component component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static List<opencv_core.CvRect> detectBlobs(opencv_core.IplImage input) {
        opencv_core.CvSeq contour;
        opencv_core.IplImage clone = input.clone();
        opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
        opencv_imgproc.cvFindContours(clone, storage, contour, Loader.sizeof(opencv_core.CvContour.class), 0, 2);
        ArrayList<opencv_core.CvRect> rects = Lists.newArrayList();
        for (contour = new opencv_core.CvSeq(null); contour != null && !contour.isNull(); contour = contour.h_next()) {
            if (contour.elem_size() <= 0) continue;
            opencv_core.CvRect boundingRect = org.bytedeco.javacpp.opencv_imgproc.cvBoundingRect(contour, 0);
            rects.add(boundingRect);
        }
        return rects;
    }

    public static BufferedImage createImageFrom(Component component) {
        Dimension size = component.getPreferredSize();
        if (size.width == 0 || size.height == 0) {
            size = component.getSize();
        }
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }

    public static void negate(opencv_core.IplImage src, opencv_core.IplImage dest) {
        org.bytedeco.javacpp.opencv_core.cvSubRS(src, org.bytedeco.javacpp.opencv_core.cvScalarAll(255.0), dest, null);
    }

    public static opencv_core.IplImage createGrayImageFrom(opencv_core.IplImage input) {
        if (input.nChannels() == 3) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(input), 8, 1);
            org.bytedeco.javacpp.opencv_imgproc.cvCvtColor(input, gray, 6);
            return gray;
        }
        if (input.nChannels() == 4) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(input), 8, 1);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI(input, 3);
            org.bytedeco.javacpp.opencv_core.cvCopy(input, gray);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI(input, 0);
            return gray;
        }
        if (input.nChannels() == 2) {
            opencv_core.IplImage gray = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(input), 8, 1);
            opencv_core.IplImage alpha = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(input), 8, 1);
            opencv_core.IplImage white = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(input), 8, 1);
            org.bytedeco.javacpp.opencv_core.cvSet(white, opencv_core.CvScalar.WHITE);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI(input, 1);
            org.bytedeco.javacpp.opencv_core.cvCopy(input, gray);
            org.bytedeco.javacpp.opencv_core.cvSetImageCOI(input, 2);
            org.bytedeco.javacpp.opencv_core.cvCopy(input, alpha);
            org.bytedeco.javacpp.opencv_core.cvCopy(gray, white, alpha);
            return white;
        }
        return input;
    }

    public static opencv_core.IplImage computeForegroundMaskOf(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(grayImage), 8, 1);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        opencv_core.IplConvKernel kernel = opencv_core.IplConvKernel.create(3, 3, 1, 1, 0, null);
        org.bytedeco.javacpp.opencv_imgproc.cvDilate(foregroundMask, foregroundMask, kernel, 2);
        kernel.release();
        return foregroundMask;
    }

    public static opencv_core.IplImage computeEdges(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(grayImage), 8, 1);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        return foregroundMask;
    }

    public static opencv_core.IplImage getForeground(opencv_core.IplImage inputImage) {
        opencv_core.IplImage grayImage = VisionUtils.createGrayImageFrom(inputImage);
        opencv_core.IplImage foregroundMask = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(grayImage), 8, 1);
        opencv_core.IplImage foreground = opencv_core.IplImage.create(org.bytedeco.javacpp.opencv_core.cvGetSize(inputImage), 8, 3);
        org.bytedeco.javacpp.opencv_imgproc.cvCanny(grayImage, foregroundMask, 33.0, 66.5, 3);
        opencv_core.IplConvKernel kernel = opencv_core.IplConvKernel.create(3, 3, 1, 1, 0, null);
        org.bytedeco.javacpp.opencv_imgproc.cvDilate(foregroundMask, foregroundMask, kernel, 1);
        kernel.release();
        org.bytedeco.javacpp.opencv_core.cvSet(foreground, org.bytedeco.javacpp.opencv_core.cvScalarAll(255.0));
        org.bytedeco.javacpp.opencv_core.cvCopy(inputImage, foreground, foregroundMask);
        return foreground;
    }

    public static BufferedImage paintBlobsOnImage(BufferedImage image, List<opencv_core.CvRect> blobs) {
        return new BlobPainter(image, blobs).render();
    }

    public static opencv_core.IplImage cloneWithoutAlphaChannel(opencv_core.IplImage bgra) {
        opencv_core.IplImage bgr = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 3);
        opencv_core.IplImage alpha = opencv_core.IplImage.create(bgra.width(), bgra.height(), 8, 1);
        opencv_core.CvArr[] in = new opencv_core.IplImage[]{bgra};
        opencv_core.CvArr[] out = new opencv_core.IplImage[]{bgr, alpha};
        int[] from_to = new int[]{0, 3, 1, 0, 2, 1, 3, 2};
        opencv_core.cvMixChannels(in, 1, out, 2, from_to, 4);
        return bgr;
    }
}

