/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api.visual;

import com.google.common.collect.Lists;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.sikuli.api.SikuliRuntimeException;
import org.sikuli.api.visual.Canvas;
import org.sikuli.api.visual.PNodeFactory;
import org.sikuli.api.visual.ScreenDisplayable;
import org.sikuli.api.visual.element.Element;

public class ImageCanvas
extends Canvas {
    private BufferedImage backgroundImage;
    List<ScreenDisplayable> displayableList = Lists.newArrayList();

    public ImageCanvas(URL imageUrl) {
        try {
            this.backgroundImage = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new SikuliRuntimeException(e);
        }
    }

    public ImageCanvas(BufferedImage image) {
        this.backgroundImage = image;
    }

    @Override
    public void display(int seconds) {
    }

    @Override
    public void display(double seconds) {
    }

    @Override
    public void displayWhile(Runnable runnable) {
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public BufferedImage createImage() {
        PCanvas canvas = new PCanvas();
        PLayer layer = canvas.getLayer();
        PImage background = new PImage(this.backgroundImage);
        layer.addChild(background);
        canvas.setBounds(0, 0, this.backgroundImage.getWidth(), this.backgroundImage.getHeight());
        PLayer foregroundLayer = new PLayer();
        layer.addChild(foregroundLayer);
        layer.addChild(foregroundLayer);
        for (Element element : this.getElements()) {
            PNode node = PNodeFactory.createFrom(element);
            foregroundLayer.addChild(node);
        }
        return ImageCanvas.createComponentImage(canvas);
    }

    public static BufferedImage createComponentImage(Component component) {
        Dimension size = component.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 2);
        Graphics2D g2 = image.createGraphics();
        component.paint(g2);
        g2.dispose();
        return image;
    }
}

