/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.api.ModelPart;
import org.sikuli.api.VisualModel;

class FourCornerModel
extends VisualModel {
    static final double MIN_ASPECT_RATIO = (double)0.2f;
    private ModelPart topLeft;
    private ModelPart bottomLeft;
    private ModelPart topRight;
    private ModelPart bottomRight;

    FourCornerModel() {
    }

    public static FourCornerModel learnFrom(BufferedImage trainingImage) {
        FourCornerModel model = new FourCornerModel();
        BufferedImage trimmedModelImage = trainingImage;
        int d = 12;
        int w = trimmedModelImage.getWidth();
        int h = trimmedModelImage.getHeight();
        BufferedImage s = trimmedModelImage;
        model.topLeft = new ModelPart(new Rectangle(0, 0, 12, 12), s);
        model.topRight = new ModelPart(new Rectangle(w - 12, 0, 12, 12), s);
        model.bottomRight = new ModelPart(new Rectangle(w - 12, h - 12, 12, 12), s);
        model.bottomLeft = new ModelPart(new Rectangle(0, h - 12, 12, 12), s);
        ArrayList<ModelPart> parts = Lists.newArrayList(model.topLeft, model.topRight, model.bottomRight, model.bottomLeft);
        return model;
    }

    public ModelPart getTopLeft() {
        return this.topLeft;
    }

    public ModelPart getBottomLeft() {
        return this.bottomLeft;
    }

    public ModelPart getTopRight() {
        return this.topRight;
    }

    public ModelPart getBottomRight() {
        return this.bottomRight;
    }
}

