/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sikuli.api.DefaultScreenRegion;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.Target;
import org.sikuli.core.search.TemplateMatcher;

public abstract class DefaultTarget
implements Target {
    private double minScore = 0.0;
    private int limit = 0;
    private Target.Ordering ordering = Target.Ordering.DEFAULT;

    protected double getDefaultMinScore() {
        return 0.0;
    }

    protected int getDefaultLimit() {
        return 100;
    }

    public DefaultTarget() {
        this.setMinScore(this.getDefaultMinScore());
        this.setLimit(this.getDefaultLimit());
    }

    @Override
    public double getMinScore() {
        return this.minScore;
    }

    @Override
    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public Target.Ordering getOrdering() {
        return this.ordering;
    }

    @Override
    public void setOrdering(Target.Ordering ordering) {
        this.ordering = ordering;
    }

    protected abstract List<ScreenRegion> getUnorderedMatches(ScreenRegion var1);

    protected static List<ScreenRegion> convertToScreenRegions(ScreenRegion parent, List<TemplateMatcher.Result> rms) {
        ArrayList<ScreenRegion> irs = Lists.newArrayList();
        for (TemplateMatcher.Result rm : rms) {
            DefaultScreenRegion ir = new DefaultScreenRegion(parent, rm.getX(), rm.getY(), rm.getWidth(), rm.getHeight());
            ir.setScore(rm.getScore());
            irs.add(ir);
        }
        return irs;
    }

    @Override
    public List<ScreenRegion> doFindAll(ScreenRegion screenRegion) {
        List<ScreenRegion> ScreenRegions = this.getUnorderedMatches(screenRegion);
        if (this.ordering == Target.Ordering.TOP_DOWN) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a, ScreenRegion b) {
                    return a.getBounds().y - b.getBounds().y;
                }
            });
        } else if (this.ordering == Target.Ordering.BOTTOM_UP) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a, ScreenRegion b) {
                    return b.getBounds().y - a.getBounds().y;
                }
            });
        } else if (this.ordering == Target.Ordering.LEFT_RIGHT) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a, ScreenRegion b) {
                    return a.getBounds().x - b.getBounds().x;
                }
            });
        } else if (this.ordering == Target.Ordering.RIGHT_LEFT) {
            Collections.sort(ScreenRegions, new Comparator<ScreenRegion>(){

                @Override
                public int compare(ScreenRegion a, ScreenRegion b) {
                    return b.getBounds().x - a.getBounds().x;
                }
            });
        }
        return ScreenRegions;
    }

    public BufferedImage toImage() {
        return null;
    }
}

