/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.api;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.bytedeco.javacpp.opencv_core;
import org.sikuli.api.ImageTarget;
import org.sikuli.api.ScreenRegion;
import org.sikuli.api.SearchByTextureAndColorAtOriginalResolution;
import org.sikuli.core.search.TemplateMatcher;

public class ColorImageTarget
extends ImageTarget {
    public ColorImageTarget(URL url) {
        super(url);
    }

    public ColorImageTarget(BufferedImage targetImage) {
        super(targetImage);
    }

    public ColorImageTarget(File file) {
        super(file);
    }

    @Override
    protected double getDefaultMinScore() {
        return 0.9;
    }

    @Override
    protected List<ScreenRegion> getUnorderedMatches(ScreenRegion screenRegion) {
        SearchByTextureAndColorAtOriginalResolution.ColorRegionMatch m;
        BufferedImage screenImage = screenRegion.capture();
        SearchByTextureAndColorAtOriginalResolution s = new SearchByTextureAndColorAtOriginalResolution(opencv_core.IplImage.createFrom(screenImage), opencv_core.IplImage.createFrom(this.targetImage));
        s.execute();
        ArrayList<TemplateMatcher.Result> matches = Lists.newArrayList();
        while (matches.size() < this.getLimit() && (m = s.fetchNext()).getScore() >= this.getMinScore()) {
            matches.add(m);
        }
        return ColorImageTarget.convertToScreenRegions(screenRegion, matches);
    }
}

