/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.LongBuffer;
import org.bytedeco.javacpp.indexer.LongIndexer;

public class LongBufferIndexer
extends LongIndexer {
    protected LongBuffer buffer;

    public LongBufferIndexer(LongBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public long get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public LongIndexer get(int i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public long get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public LongIndexer get(int i, int j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public long get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public long get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public LongIndexer get(int[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            l[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, long l) {
        this.buffer.put(i, l);
        return this;
    }

    @Override
    public LongIndexer put(int i, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, l[offset + n]);
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, long l) {
        this.buffer.put(i * this.strides[0] + j, l);
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, l[offset + n]);
        }
        return this;
    }

    @Override
    public LongIndexer put(int i, int j, int k, long l) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, l);
        return this;
    }

    @Override
    public LongIndexer put(int[] indices, long l) {
        this.buffer.put(this.index(indices), l);
        return this;
    }

    @Override
    public LongIndexer put(int[] indices, long[] l, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, l[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

