/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;

public abstract class Indexer {
    protected int[] sizes;
    protected int[] strides;

    protected Indexer(int[] sizes, int[] strides) {
        this.sizes = sizes;
        this.strides = strides;
    }

    public int[] sizes() {
        return this.sizes;
    }

    public int[] strides() {
        return this.strides;
    }

    public int rows() {
        return this.sizes[0];
    }

    public int cols() {
        return this.sizes[1];
    }

    public int width() {
        return this.sizes[1];
    }

    public int height() {
        return this.sizes[0];
    }

    public int channels() {
        return this.sizes[2];
    }

    public int index(int ... indices) {
        int index = 0;
        for (int i = 0; i < indices.length; ++i) {
            index += indices[i] * this.strides[i];
        }
        return index;
    }

    public Object array() {
        return null;
    }

    public Buffer buffer() {
        return null;
    }

    public abstract void release();

    public abstract double getDouble(int ... var1);

    public String toString() {
        int rows = this.sizes.length > 0 ? this.sizes[0] : 1;
        int cols = this.sizes.length > 1 ? this.sizes[1] : 1;
        int channels = this.sizes.length > 2 ? this.sizes[2] : 1;
        StringBuilder s = new StringBuilder(rows > 1 ? "\n[ " : "[ ");
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (channels > 1) {
                    s.append("(");
                }
                for (int k = 0; k < channels; ++k) {
                    double v = this.getDouble(i, j, k);
                    s.append((float)v);
                    if (k >= channels - 1) continue;
                    s.append(", ");
                }
                if (channels > 1) {
                    s.append(")");
                }
                if (j >= cols - 1) continue;
                s.append(", ");
            }
            if (i >= rows - 1) continue;
            s.append("\n  ");
        }
        s.append(" ]");
        return s.toString();
    }
}

