/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.server;

import io.sterodium.rmi.protocol.MethodInvocationDto;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.server.Marshaller;
import io.sterodium.rmi.protocol.server.MethodInvocationException;
import io.sterodium.rmi.protocol.server.MethodInvoker;
import io.sterodium.rmi.protocol.server.MethodNotFoundException;
import io.sterodium.rmi.protocol.server.MethodNotVisibleException;
import io.sterodium.rmi.protocol.server.MethodParameterException;
import io.sterodium.rmi.protocol.server.ObjectLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiFacade {
    private static final Logger LOG = LoggerFactory.getLogger(RmiFacade.class);
    private static final String CACHE_SIZE_WARNING = "Please make sure objects cache size is big enough for temporary objects (in chained invocation).";
    private ObjectLocator objectLocator = new ObjectLocator();
    private Marshaller marshaller = new Marshaller(this.objectLocator);
    private MethodInvoker invoker = new MethodInvoker(this.objectLocator);

    public MethodInvocationResultDto invoke(String objectId, MethodInvocationDto invocation) {
        Class<?> returnType;
        Object result;
        Object object = this.objectLocator.get(objectId);
        if (object == null) {
            String message = String.format("Object (%s) is not found.", objectId);
            LOG.error(message);
            LOG.error(CACHE_SIZE_WARNING);
            return new MethodInvocationResultDto(-32004, message, CACHE_SIZE_WARNING);
        }
        try {
            MethodInvoker.InvocationResult invocationResult = this.invoker.invoke(object, invocation);
            result = invocationResult.getResult();
            returnType = invocationResult.getResultClass();
        }
        catch (MethodNotFoundException e) {
            return new MethodInvocationResultDto(-32601, "Method not found", e.getMessage());
        }
        catch (MethodNotVisibleException e) {
            return new MethodInvocationResultDto(-32601, "Method not visible", e.getMessage());
        }
        catch (MethodParameterException e) {
            return new MethodInvocationResultDto(-32602, "Invalid params", e.getMessage());
        }
        catch (MethodInvocationException e) {
            return new MethodInvocationResultDto(-32000, "Method invocation error", e.getMessage());
        }
        catch (RuntimeException e) {
            LOG.error("Something went wrong during remote method invocation", e);
            return new MethodInvocationResultDto(-32603, "Protocol error", e.getMessage());
        }
        return this.marshaller.toResponse(result, returnType);
    }

    public void add(String objectId, Object object) {
        this.objectLocator.addPermanentObject(objectId, object);
    }
}

