/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.server;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class ClassUtils {
    public static final String ARRAY_SUFFIX = "[]";
    private static final String INTERNAL_ARRAY_PREFIX = "[L";
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP = new HashMap();

    private ClassUtils() {
    }

    public static Class forName(String name) throws ClassNotFoundException, LinkageError {
        return ClassUtils.forName(name, ClassUtils.getDefaultClassLoader());
    }

    public static Class forName(String name, ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        Class<?> clazz = ClassUtils.resolvePrimitiveClassName(name);
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        int internalArrayMarker = name.indexOf(INTERNAL_ARRAY_PREFIX);
        if (internalArrayMarker != -1 && name.endsWith(";")) {
            String elementClassName = null;
            if (internalArrayMarker == 0) {
                elementClassName = name.substring(INTERNAL_ARRAY_PREFIX.length(), name.length() - 1);
            } else if (name.startsWith("[")) {
                elementClassName = name.substring(1);
            }
            Class elementClass = ClassUtils.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader classLoaderToUse = classLoader;
        if (classLoaderToUse == null) {
            classLoaderToUse = ClassUtils.getDefaultClassLoader();
        }
        return classLoaderToUse.loadClass(name);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    public static Class<?> getFirstPublicType(Class<?> returnType) {
        if (!Modifier.isPublic(returnType.getModifiers())) {
            Class<?>[] interfaces = returnType.getInterfaces();
            if (interfaces.length > 0) {
                return interfaces[0];
            }
            return ClassUtils.getFirstPublicType(returnType.getSuperclass());
        }
        return returnType;
    }

    static {
        HashSet<Class<Object>> primitiveTypes = new HashSet<Class<Object>>();
        primitiveTypes.add(Boolean.TYPE);
        primitiveTypes.add(Byte.TYPE);
        primitiveTypes.add(Character.TYPE);
        primitiveTypes.add(Double.TYPE);
        primitiveTypes.add(Float.TYPE);
        primitiveTypes.add(Short.TYPE);
        primitiveTypes.add(Integer.TYPE);
        primitiveTypes.add(Long.TYPE);
        primitiveTypes.add(boolean[].class);
        primitiveTypes.add(byte[].class);
        primitiveTypes.add(char[].class);
        primitiveTypes.add(double[].class);
        primitiveTypes.add(float[].class);
        primitiveTypes.add(short[].class);
        primitiveTypes.add(int[].class);
        primitiveTypes.add(long[].class);
        for (Class clazz : primitiveTypes) {
            PRIMITIVE_TYPE_NAME_MAP.put(clazz.getName(), clazz);
        }
    }
}

