/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import io.sterodium.rmi.protocol.client.RmiTransport;
import io.sterodium.rmi.protocol.server.TargetObjectNotFoundException;
import io.sterodium.rmi.protocol.server.TargetServerException;
import java.io.IOException;
import java.net.URLEncoder;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

class RestTransport
implements RmiTransport {
    private final HttpHost httpHost;
    private HttpClient httpClient = HttpClientBuilder.create().build();
    private String path;

    public RestTransport(String host, int port, String path) {
        this.httpHost = new HttpHost(host, port);
        this.path = path;
    }

    @Override
    public String send(String objectId, String json) throws IOException {
        HttpPost request = new HttpPost(this.path + "/" + URLEncoder.encode(objectId, "UTF-8"));
        request.setEntity(new StringEntity(json));
        HttpResponse httpResponse = this.httpClient.execute(this.httpHost, request);
        int statusCode = this.getStatusCode(httpResponse);
        if (statusCode == 404) {
            throw new TargetObjectNotFoundException(String.format("Widget %s is not available at %s", objectId, this.getUrl(request)));
        }
        if (statusCode != 200) {
            String messageFromServer = EntityUtils.toString(httpResponse.getEntity());
            String message = "Widget %s invocation failed (expected 200, but was %s): %s";
            throw new TargetServerException(String.format(message, objectId, statusCode, messageFromServer));
        }
        return EntityUtils.toString(httpResponse.getEntity());
    }

    public void reset() throws IOException {
        HttpDelete request = new HttpDelete(this.path);
        HttpResponse httpResponse = this.httpClient.execute(this.httpHost, request);
        int statusCode = this.getStatusCode(httpResponse);
        if (statusCode != 200) {
            throw new RuntimeException(String.format("Widgets reset operation failed (expected 200, but was %s)", statusCode));
        }
    }

    private int getStatusCode(HttpResponse httpResponse) {
        return httpResponse.getStatusLine().getStatusCode();
    }

    private String getUrl(HttpRequestBase request) {
        return String.format("(%s) http://%s%s", request.getMethod(), this.httpHost.toHostString(), request.getURI());
    }
}

