/*
 * Decompiled with CFR 0.152.
 */
package io.sterodium.rmi.protocol.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Primitives;
import io.sterodium.rmi.protocol.MethodInvocationResultDto;
import io.sterodium.rmi.protocol.client.RemoteInvoker;
import io.sterodium.rmi.protocol.client.RemoteObjectProxyFactory;
import io.sterodium.rmi.protocol.json.PrimitiveTypes;
import io.sterodium.rmi.protocol.server.MethodInvocationException;
import io.sterodium.rmi.protocol.server.MethodNotFoundException;
import io.sterodium.rmi.protocol.server.MethodParameterException;
import io.sterodium.rmi.protocol.server.RmiException;
import io.sterodium.rmi.protocol.server.TargetObjectNotFoundException;
import io.sterodium.rmi.protocol.server.UnsupportedProtocolException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RemoteObjectMethodInterceptor
implements MethodInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteObjectMethodInterceptor.class);
    private RemoteObjectProxyFactory proxyFactory;
    private RemoteInvoker invoker;
    private String widgetId;

    public RemoteObjectMethodInterceptor(RemoteObjectProxyFactory proxyFactory, RemoteInvoker invoker, String widgetId) {
        this.proxyFactory = proxyFactory;
        this.invoker = invoker;
        this.widgetId = widgetId;
    }

    @Override
    public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return methodProxy.invokeSuper(proxy, arguments);
        }
        if ("toString".equals(method.getName()) && arguments.length == 0) {
            return methodProxy.invokeSuper(proxy, arguments);
        }
        return this.invoke(method, arguments);
    }

    Object invoke(Method method, Object[] arguments) {
        try {
            MethodInvocationResultDto methodResponse = this.invoker.invoke(this.widgetId, method, arguments);
            this.checkErrorCodes(methodResponse);
            String responseValue = methodResponse.getValue();
            return responseValue == null ? null : this.convertToType(responseValue, method.getReturnType(), methodResponse.getType());
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Unmapped response", e);
            return null;
        }
    }

    @VisibleForTesting
    protected void checkErrorCodes(MethodInvocationResultDto response) {
        MethodInvocationResultDto.Error error = response.getError();
        if (error == null) {
            return;
        }
        int code = error.getCode();
        String message = error.getMessage();
        String details = error.getData();
        switch (code) {
            case -32700: {
                throw new UnsupportedProtocolException(code, message, details);
            }
            case -32600: {
                throw new UnsupportedProtocolException(code, message, details);
            }
            case -32601: {
                throw new MethodNotFoundException(code, message, details);
            }
            case -32602: {
                throw new MethodParameterException(code, message, details);
            }
            case -32603: {
                throw new UnsupportedProtocolException(code, message, details);
            }
            case -32000: {
                throw new MethodInvocationException(code, message, details);
            }
            case -32004: {
                throw new TargetObjectNotFoundException(code, message, details);
            }
        }
        LOGGER.warn("Unsupported error code '{}': '{}' ({}))", code, message, details);
        throw new RmiException(code, message, details);
    }

    private Object convertToType(String response, Class<?> type, String responseType) throws ClassNotFoundException {
        LOGGER.info(String.format("Converting response '%s' to type %s or %s", response, type, responseType));
        if (PrimitiveTypes.isVoid(type)) {
            return null;
        }
        if (String.class.equals(type)) {
            return response;
        }
        if (PrimitiveTypes.isCharacter(type)) {
            return Character.valueOf(response.toCharArray()[0]);
        }
        if (PrimitiveTypes.isPrimitive(type)) {
            return this.parseString(response, type);
        }
        return this.proxyFactory.create(Class.forName(responseType), response);
    }

    Object parseString(String value, Class<?> type) {
        try {
            Class<?> targetType = Primitives.wrap(type);
            return targetType.getConstructor(String.class).newInstance(value);
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse string and construct object", e);
            return null;
        }
    }
}

